/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter.value;

import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.value.ParameterValues;

public class ParameterValueGrid
extends ParameterValues {
    public static final int SCALE_LINEAR = 0;
    public static final int SCALE_QUADRATIC = 1;
    public static final int SCALE_LOGARITHMIC = 2;
    public static final int SCALE_LOGARITHMIC_LEGACY = 3;
    public static final String[] SCALES = new String[]{"linear", "quadratic", "logarithmic", "logarithmic (legacy)"};
    public static final int DEFAULT_STEPS = 10;
    public static final int DEFAULT_SCALE = 0;
    private String min;
    private String max;
    private String steps;
    private String stepSize;
    private int scale;

    public ParameterValueGrid(Operator operator, ParameterType type, String min, String max) {
        this(operator, type, min, max, Integer.toString(10), 0);
    }

    public ParameterValueGrid(Operator operator, ParameterType type, String min, String max, String stepSize) {
        super(operator, type);
        this.min = min;
        this.max = max;
        this.steps = null;
        this.stepSize = stepSize;
        this.scale = 0;
    }

    public ParameterValueGrid(Operator operator, ParameterType type, String min, String max, String steps, int scale) {
        super(operator, type);
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.scale = scale;
    }

    public ParameterValueGrid(Operator operator, ParameterType type, String min, String max, String steps, String scaleName) {
        super(operator, type);
        this.min = min;
        this.max = max;
        this.steps = steps;
        this.scale = 0;
        for (int i = 0; i < SCALES.length; ++i) {
            if (!scaleName.equals(SCALES[i])) continue;
            this.scale = i;
            break;
        }
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMin() {
        return this.min;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public String getMax() {
        return this.max;
    }

    public void setSteps(String steps) {
        this.steps = steps;
    }

    public String getSteps() {
        return this.steps;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public void move(int index, int direction) {
    }

    @Override
    public String[] getValuesArray() {
        double[] values = this.getValues();
        String[] valuesArray = new String[values.length];
        if (this.type instanceof ParameterTypeInt) {
            for (int i = 0; i < values.length; ++i) {
                valuesArray[i] = Integer.toString((int)values[i]);
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                valuesArray[i] = Double.toString(values[i]);
            }
        }
        return valuesArray;
    }

    public double[] getValues() {
        double[] values = null;
        if (this.stepSize != null && this.steps == null) {
            this.steps = Integer.toString((int)(Double.valueOf(this.max) - Double.valueOf(this.min)) / Integer.parseInt(this.stepSize));
        }
        switch (this.scale) {
            case 0: {
                values = this.scalePolynomial(Integer.parseInt(this.steps), 1.0);
                break;
            }
            case 1: {
                values = this.scalePolynomial(Integer.parseInt(this.steps), 2.0);
                break;
            }
            case 2: {
                values = this.scaleLogarithmic(Integer.parseInt(this.steps));
                break;
            }
            case 3: {
                values = this.scaleLogarithmicLegacy(Integer.parseInt(this.steps));
                break;
            }
            default: {
                values = this.scalePolynomial(Integer.parseInt(this.steps), 1.0);
            }
        }
        if (this.type instanceof ParameterTypeInt) {
            if (values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = Math.round(values[i]);
                }
                int count = 1;
                for (int i = 1; i < values.length; ++i) {
                    if (values[i] == values[i - 1]) continue;
                    ++count;
                }
                double[] uniqueValues = new double[count];
                uniqueValues[0] = values[0];
                count = 1;
                for (int i = 1; i < values.length; ++i) {
                    if (values[i] == values[i - 1]) continue;
                    uniqueValues[count] = values[i];
                    ++count;
                }
                return uniqueValues;
            }
            return values;
        }
        return values;
    }

    private double[] scalePolynomial(int steps, double power) {
        double[] values = new double[steps + 1];
        double minValue = Double.parseDouble(this.min);
        double maxValue = Double.parseDouble(this.max);
        for (int i = 0; i < steps + 1; ++i) {
            values[i] = minValue + Math.pow((double)i / (double)steps, power) * (maxValue - minValue);
        }
        return values;
    }

    private double[] scaleLogarithmic(int steps) {
        double minValue = Double.parseDouble(this.min);
        double maxValue = Double.parseDouble(this.max);
        double[] values = new double[steps + 1];
        for (int i = 0; i < steps + 1; ++i) {
            values[i] = Math.pow(maxValue / minValue, (double)i / (double)steps) * minValue;
        }
        return values;
    }

    private double[] scaleLogarithmicLegacy(int steps) {
        double minValue = Double.parseDouble(this.min);
        double maxValue = Double.parseDouble(this.max);
        double[] values = new double[steps + 1];
        double offset = 1.0 - minValue;
        for (int i = 0; i < steps + 1; ++i) {
            values[i] = Math.pow(maxValue + offset, (double)i / (double)steps) - offset;
        }
        return values;
    }

    @Override
    public int getNumberOfValues() {
        return Integer.parseInt(this.steps) + 1;
    }

    @Override
    public String getValuesString() {
        return "[" + this.min + ";" + this.max + ";" + this.steps + ";" + SCALES[this.scale] + "]";
    }

    public String toString() {
        return "grid: " + this.min + " - " + this.max + " (" + this.steps + ", " + SCALES[this.scale] + ")";
    }
}

