/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter.conditions;

import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;

public class NonEqualStringCondition
extends ParameterCondition {
    private String[] types;

    public NonEqualStringCondition(ParameterHandler handler, String conditionParameter, boolean becomeMandatory, String ... types) {
        super(handler, conditionParameter, becomeMandatory);
        this.types = types;
    }

    @Override
    public boolean isConditionFullfilled() {
        String isType;
        boolean equals = false;
        try {
            isType = this.parameterHandler.getParameterAsString(this.conditionParameter);
        }
        catch (UndefinedParameterError e) {
            return false;
        }
        for (String type : this.types) {
            if (!type.equals(isType)) continue;
            equals = true;
            break;
        }
        return !equals;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.types.length > 1) {
            builder.append(this.conditionParameter.replace('_', ' ') + " \u2209 {");
            for (int i = 0; i < this.types.length; ++i) {
                builder.append(this.types[i]);
                if (i + 1 >= this.types.length) continue;
                builder.append(", ");
            }
            builder.append("}");
        } else if (this.types.length > 0) {
            builder.append(this.conditionParameter.replace('_', ' ') + " \u2260 " + this.types[0]);
        }
        return builder.toString();
    }
}

