/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter.conditions;

import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.ParameterCondition;

public class EqualTypeCondition
extends ParameterCondition {
    private int[] types;
    private String[] options;

    public EqualTypeCondition(ParameterHandler handler, String conditionParameter, String[] options, boolean becomeMandatory, int ... types) {
        super(handler, conditionParameter, becomeMandatory);
        this.types = types;
        this.options = options;
    }

    @Override
    public boolean isConditionFullfilled() {
        int isType;
        boolean equals = false;
        try {
            isType = this.parameterHandler.getParameterAsInt(this.conditionParameter);
        }
        catch (UndefinedParameterError e) {
            return false;
        }
        for (int type : this.types) {
            equals |= isType == type;
        }
        return equals;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.types.length > 1) {
            builder.append(this.conditionParameter.replace('_', ' ') + " \u2208 {");
            for (int i = 0; i < this.types.length; ++i) {
                builder.append(this.options[this.types[i]]);
                if (i + 1 >= this.types.length) continue;
                builder.append(", ");
            }
            builder.append("}");
        } else if (this.types.length > 0) {
            builder.append(this.conditionParameter.replace('_', ' ') + " = " + this.options[this.types[0]]);
        }
        return builder.toString();
    }
}

