/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Parameters
extends AbstractObservable<String>
implements Cloneable,
Iterable<String> {
    public static final char PAIR_SEPARATOR = '\u241d';
    public static final char RECORD_SEPARATOR = '\u241e';
    private final Map<String, String> keyToValueMap = new LinkedHashMap<String, String>();
    private final Map<String, ParameterType> keyToTypeMap = new LinkedHashMap<String, ParameterType>();

    public Parameters() {
    }

    public Parameters(List<ParameterType> parameterTypes) {
        for (ParameterType type : parameterTypes) {
            this.addParameterType(type);
        }
    }

    public Collection<ParameterType> getParameterTypes() {
        return this.keyToTypeMap.values();
    }

    public void addParameterType(ParameterType type) {
        this.keyToTypeMap.put(type.getKey(), type);
    }

    public Object clone() {
        Parameters clone = new Parameters();
        for (String key : this.keyToValueMap.keySet()) {
            String value = this.keyToValueMap.get(key);
            ParameterType type = this.keyToTypeMap.get(key);
            if (type == null) continue;
            clone.keyToValueMap.put(key, value);
        }
        for (String key : this.keyToTypeMap.keySet()) {
            clone.keyToTypeMap.put(key, this.keyToTypeMap.get(key));
        }
        return clone;
    }

    @Override
    public Iterator<String> iterator() {
        return this.keyToTypeMap.keySet().iterator();
    }

    public ParameterType getParameterType(String key) {
        return this.keyToTypeMap.get(key);
    }

    public boolean setParameter(String key, String value) {
        boolean knownType = true;
        if (value == null) {
            this.keyToValueMap.remove(key);
        } else {
            ParameterType type = this.keyToTypeMap.get(key);
            if (type != null) {
                value = type.transformNewValue(value);
                knownType = true;
            }
            this.keyToValueMap.put(key, value);
        }
        this.fireUpdate(key);
        return knownType;
    }

    @Deprecated
    public void setParameterWithoutCheck(String key, String value) {
        this.setParameter(key, value);
    }

    public String getParameter(String key) throws UndefinedParameterError {
        if (this.keyToValueMap.containsKey(key)) {
            return this.keyToValueMap.get(key);
        }
        ParameterType type = this.keyToTypeMap.get(key);
        if (type == null) {
            return null;
        }
        Object defaultValue = type.getDefaultValue();
        if (defaultValue == null && !type.isOptional()) {
            LogService.getRoot().fine("Parameter '" + key + "' is not set and has no default value.");
            throw new UndefinedParameterError(key);
        }
        LogService.getRoot().finer("Parameter '" + key + "' is not set. Using default ('" + type.toString(defaultValue) + "').");
        if (defaultValue == null) {
            return null;
        }
        return type.toString(defaultValue);
    }

    public String getParameterAsSpecified(String key) {
        return this.keyToValueMap.get(key);
    }

    public String getParameterOrNull(String key) {
        if (this.keyToValueMap.containsKey(key)) {
            return this.keyToValueMap.get(key);
        }
        ParameterType type = this.keyToTypeMap.get(key);
        if (type == null) {
            return null;
        }
        Object value = type.getDefaultValue();
        if (value == null && !type.isOptional()) {
            LogService.getRoot().finer("Parameter '" + key + "' is not set. Using null.");
            return null;
        }
        LogService.getRoot().finer("Parameter '" + key + "' is not set. Using default ('" + type.toString(value) + "').");
        if (value == null) {
            return null;
        }
        return type.toString(value);
    }

    public Set<String> getKeys() {
        return this.keyToTypeMap.keySet();
    }

    public Set<String> getDefinedKeys() {
        return this.keyToValueMap.keySet();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Parameters)) {
            return false;
        }
        Parameters p = (Parameters)o;
        return ((Object)p.keyToValueMap).equals(this.keyToValueMap);
    }

    public int hashCode() {
        return ((Object)this.keyToValueMap).hashCode();
    }

    public void appendXML(Element toElement, boolean hideDefault, Document doc) {
        for (String key : this.keyToTypeMap.keySet()) {
            Element paramElement;
            String value = this.keyToValueMap.get(key);
            ParameterType type = this.keyToTypeMap.get(key);
            if (type != null) {
                paramElement = type.getXML(key, value, hideDefault, doc);
            } else {
                paramElement = doc.createElement("parameter");
                paramElement.setAttribute("key", key);
                paramElement.setAttribute("value", value.toString());
            }
            if (paramElement == null) continue;
            toElement.appendChild(paramElement);
        }
    }

    @Deprecated
    public String getXML(String indent, boolean hideDefault) {
        StringBuffer result = new StringBuffer();
        for (String key : this.keyToTypeMap.keySet()) {
            String value = this.keyToValueMap.get(key);
            ParameterType type = this.keyToTypeMap.get(key);
            if (type != null) {
                result.append(type.getXML(indent, key, value, hideDefault));
                continue;
            }
            result.append(indent + "<parameter key=\"" + key + "\"\tvalue=\"" + value.toString() + "\"/>" + Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String toString() {
        return this.keyToValueMap.toString();
    }

    @Deprecated
    public static String transformList2String(List<String[]> parameterList) {
        return ParameterTypeList.transformList2String(parameterList);
    }

    @Deprecated
    public static List<String[]> transformString2List(String listString) {
        return ParameterTypeList.transformString2List(listString);
    }

    public void notifyRenaming(String oldName, String newName) {
        for (String key : this.keyToValueMap.keySet()) {
            ParameterType type = this.keyToTypeMap.get(key);
            String value = this.keyToValueMap.get(key);
            if (type == null || value == null) continue;
            this.keyToValueMap.put(key, type.notifyOperatorRenaming(oldName, newName, value));
        }
    }

    public void renameParameter(String oldAttributeName, String newAttributeName) {
        String value = this.keyToValueMap.get(oldAttributeName);
        if (value != null) {
            this.keyToValueMap.remove(oldAttributeName);
            this.keyToValueMap.put(newAttributeName, value);
        }
    }

    public boolean isSet(String parameterKey) {
        if (this.keyToValueMap.containsKey(parameterKey)) {
            return true;
        }
        ParameterType type = this.keyToTypeMap.get(parameterKey);
        if (type == null) {
            return false;
        }
        return type.getDefaultValue() != null;
    }

    public boolean isSpecified(String key) {
        return this.keyToValueMap.containsKey(key);
    }

    public void copyFrom(Parameters parameters) {
        this.keyToValueMap.putAll(parameters.keyToValueMap);
    }

    public void setAll(Parameters parameters) {
        this.keyToValueMap.clear();
        this.keyToValueMap.putAll(parameters.keyToValueMap);
        this.fireUpdate();
    }

    public void addAll(Parameters parameters) {
        this.keyToValueMap.putAll(parameters.keyToValueMap);
        this.fireUpdate();
    }
}

