/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeSingle;

public class ParameterTypeValue
extends ParameterTypeSingle {
    private static final long serialVersionUID = -5863628921324775010L;
    private static final String ESCAPE_CHAR = "\\";
    private static final String ESCAPE_CHAR_REGEX = "\\\\";
    private static final String SEPERATOR_CHAR_REGEX = "\\.";
    private static final String SEPERATOR_CHAR = ".";

    public ParameterTypeValue(String key, String description) {
        super(key, description);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
    }

    @Override
    public String getRange() {
        return "values";
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public String notifyOperatorRenaming(String oldOperatorName, String newOperatorName, String parameterValue) {
        OperatorValueSelection selection = ParameterTypeValue.transformString2OperatorValueSelection(parameterValue);
        if (selection != null) {
            if (selection.getOperator().equals(oldOperatorName)) {
                selection.operatorName = newOperatorName;
            }
            return ParameterTypeValue.transformOperatorValueSelection2String(selection);
        }
        return parameterValue;
    }

    public static OperatorValueSelection transformString2OperatorValueSelection(String parameterValue) {
        String[] unescaped = parameterValue.split("(?<=[^\\\\])\\.", -1);
        for (int i = 0; i < unescaped.length; ++i) {
            unescaped[i] = ParameterTypeValue.unescape(unescaped[i]);
        }
        OperatorValueSelection selection = new OperatorValueSelection();
        if (unescaped.length == 4) {
            selection.operatorName = unescaped[1];
            selection.valueParameterName = unescaped[3];
            selection.isValue = unescaped[2].equals("value");
            return selection;
        }
        return null;
    }

    private static String unescape(String escapedString) {
        escapedString = escapedString.replace(SEPERATOR_CHAR_REGEX, SEPERATOR_CHAR);
        escapedString = escapedString.replace(ESCAPE_CHAR_REGEX, ESCAPE_CHAR);
        return escapedString;
    }

    public static String transformOperatorValueSelection2String(OperatorValueSelection selection) {
        String operator = selection.operatorName != null ? selection.getOperator().replace(ESCAPE_CHAR, ESCAPE_CHAR_REGEX) : "";
        operator = operator.replace(SEPERATOR_CHAR, SEPERATOR_CHAR_REGEX);
        String value = selection.valueParameterName != null ? selection.valueParameterName.replace(ESCAPE_CHAR, ESCAPE_CHAR_REGEX) : "";
        value = value.replace(SEPERATOR_CHAR, SEPERATOR_CHAR_REGEX);
        return "operator." + operator + SEPERATOR_CHAR + (selection.isValue ? "value" : "parameter") + SEPERATOR_CHAR + value;
    }

    public static class OperatorValueSelection {
        private String operatorName;
        private String valueParameterName;
        private boolean isValue;

        public OperatorValueSelection() {
        }

        public OperatorValueSelection(String operatorName, boolean isValue, String valueOrParameterName) {
            this.operatorName = operatorName;
            this.valueParameterName = valueOrParameterName;
            this.isValue = isValue;
        }

        public String getOperator() {
            return this.operatorName;
        }

        public String getParameterName() {
            if (!this.isValue) {
                return this.valueParameterName;
            }
            return null;
        }

        public String getValueName() {
            if (this.isValue) {
                return this.valueParameterName;
            }
            return null;
        }

        public boolean isValue() {
            return this.isValue;
        }
    }
}

