/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.MacroHandler;
import com.rapidminer.parameter.CombinedParameterType;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterTypeTupel
extends CombinedParameterType {
    private static final char ESCAPE_CHAR = '\\';
    private static final char XML_SEPERATOR_CHAR = '.';
    private static final char[] XML_SPECIAL_CHARACTERS = new char[]{'.'};
    private static final char INTERNAL_SEPERATOR_CHAR = '.';
    private static final char[] INTERNAL_SPECIAL_CHARACTERS = new char[]{'.'};
    private Object[] defaultValues = null;
    private ParameterType[] types;
    private static final long serialVersionUID = 7292052301201204321L;

    public ParameterTypeTupel(String key, String description, ParameterType ... parameterTypes) {
        super(key, description, parameterTypes);
        this.types = parameterTypes;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValues == null) {
            String[] defaultValues = new String[this.types.length];
            for (int i = 0; i < this.types.length; ++i) {
                defaultValues[i] = this.types[i].getDefaultValue() == null ? "" : this.types[i].getDefaultValue() + "";
            }
            return ParameterTypeTupel.transformTupel2String(defaultValues);
        }
        String[] defStrings = new String[this.defaultValues.length];
        for (int i = 0; i < this.defaultValues.length; ++i) {
            defStrings[i] = this.defaultValues[i] + "";
        }
        return ParameterTypeTupel.transformTupel2String(defStrings);
    }

    @Override
    public String getDefaultValueAsString() {
        String[] defaultStrings = new String[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            Object defaultValue = this.types[i].getDefaultValue();
            defaultStrings[i] = this.types[i].toString(defaultValue);
        }
        return ParameterTypeTupel.transformTupel2String(defaultStrings);
    }

    @Override
    public String getRange() {
        return "tupel";
    }

    @Override
    public Element getXML(String key, String value, boolean hideDefault, Document doc) {
        String[] tupel;
        Element element = doc.createElement("parameter");
        element.setAttribute("key", key);
        if (value == null) {
            Pair defltValue = (Pair)this.getDefaultValue();
            tupel = new String[]{(String)defltValue.getFirst(), (String)defltValue.getSecond()};
        } else {
            tupel = ParameterTypeTupel.transformString2Tupel(value);
        }
        StringBuilder valueString = new StringBuilder();
        boolean first = true;
        for (String part : tupel) {
            if (!first) {
                valueString.append('.');
            } else {
                first = false;
            }
            if (part == null) {
                part = "";
            }
            valueString.append(Tools.escape(part, '\\', XML_SPECIAL_CHARACTERS));
        }
        element.setAttribute("value", valueString.toString());
        return element;
    }

    @Override
    public String getXML(String indent, String key, String value, boolean hideDefault) {
        StringBuffer result = new StringBuffer();
        String valueString = value;
        if (value == null) {
            valueString = ParameterTypeTupel.transformTupel2String((Pair)this.getDefaultValue());
        }
        result.append(indent + "<parameter key=\"" + key + "\" value=\"" + valueString + "\" />" + Tools.getLineSeparator());
        return result.toString();
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValues = (Object[])defaultValue;
    }

    public ParameterType getFirstParameterType() {
        return this.types[0];
    }

    public ParameterType getSecondParameterType() {
        return this.types[1];
    }

    public ParameterType[] getParameterTypes() {
        return this.types;
    }

    public static String[] transformString2Tupel(String parameterValue) {
        if (parameterValue == null || parameterValue.isEmpty()) {
            return new String[2];
        }
        List<String> split = Tools.unescape(parameterValue, '\\', INTERNAL_SPECIAL_CHARACTERS, '.');
        while (split.size() < 2) {
            split.add(null);
        }
        return split.toArray(new String[split.size()]);
    }

    public static String transformTupel2String(String firstValue, String secondValue) {
        return Tools.escape(firstValue, '\\', INTERNAL_SPECIAL_CHARACTERS) + '.' + Tools.escape(secondValue, '\\', INTERNAL_SPECIAL_CHARACTERS);
    }

    public static String transformTupel2String(Pair<String, String> pair) {
        return ParameterTypeTupel.transformTupel2String(pair.getFirst(), pair.getSecond());
    }

    public static String transformTupel2String(String[] tupel) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tupel.length; ++i) {
            if (i > 0) {
                builder.append('.');
            }
            if (tupel[i] == null) continue;
            builder.append(Tools.escape(tupel[i], '\\', INTERNAL_SPECIAL_CHARACTERS));
        }
        return builder.toString();
    }

    @Override
    public String notifyOperatorRenaming(String oldOperatorName, String newOperatorName, String parameterValue) {
        String[] tupel = ParameterTypeTupel.transformString2Tupel(parameterValue);
        for (int i = 0; i < this.types.length; ++i) {
            tupel[i] = this.types[i].notifyOperatorRenaming(oldOperatorName, newOperatorName, tupel[i]);
        }
        return ParameterTypeTupel.transformTupel2String(tupel);
    }

    @Override
    public String transformNewValue(String value) {
        List<String> split = Tools.unescape(value, '\\', XML_SPECIAL_CHARACTERS, '.');
        StringBuilder internalEncoded = new StringBuilder();
        boolean first = true;
        for (String part : split) {
            if (!first) {
                internalEncoded.append('.');
            } else {
                first = false;
            }
            internalEncoded.append(Tools.escape(part, '\\', INTERNAL_SPECIAL_CHARACTERS));
        }
        return internalEncoded.toString();
    }

    public static String escapeForInternalRepresentation(String string) {
        return Tools.escape(string, '\\', INTERNAL_SPECIAL_CHARACTERS);
    }

    @Override
    public String substituteMacros(String parameterValue, MacroHandler mh) {
        if (parameterValue.indexOf("%{") == -1) {
            return parameterValue;
        }
        String[] tupel = ParameterTypeTupel.transformString2Tupel(parameterValue);
        String[] result = new String[tupel.length];
        for (int i = 0; i < tupel.length; ++i) {
            result[i] = this.types[i].substituteMacros(tupel[i], mh);
        }
        return ParameterTypeTupel.transformTupel2String(result);
    }
}

