/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeSingle;

public class ParameterTypeString
extends ParameterTypeSingle {
    private static final long serialVersionUID = 6451584265725535856L;
    private String defaultValue = null;
    private boolean optional = false;

    public ParameterTypeString(String key, String description, boolean optional, boolean expert) {
        this(key, description, optional);
        this.setExpert(expert);
    }

    public ParameterTypeString(String key, String description, boolean optional) {
        super(key, description);
        this.optional = optional;
        if (!optional) {
            this.setExpert(false);
        }
    }

    public ParameterTypeString(String key, String description) {
        this(key, description, true);
    }

    public ParameterTypeString(String key, String description, String defaultValue, boolean expert) {
        this(key, description, defaultValue);
        this.setExpert(expert);
    }

    public ParameterTypeString(String key, String description, String defaultValue) {
        this(key, description);
        this.defaultValue = defaultValue;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
        if (!optional) {
            this.setExpert(false);
        }
    }

    @Override
    public boolean isOptional() {
        if (super.isOptional()) {
            return this.optional;
        }
        return false;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = (String)defaultValue;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public String getRange() {
        return "string" + (this.defaultValue != null ? "; default: '" + this.defaultValue + "'" : "");
    }
}

