/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.MacroHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Tools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ParameterTypeSingle
extends ParameterType {
    private static final long serialVersionUID = 1144201124955949715L;

    public ParameterTypeSingle(String key, String description) {
        super(key, description);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Element getXML(String key, String value, boolean hideDefault, Document doc) {
        Element element = doc.createElement("parameter");
        element.setAttribute("key", key);
        if (value != null) {
            if (this.toString(value).equals(this.toString(this.getDefaultValue()))) {
                if (hideDefault) return null;
                element.setAttribute("value", value);
                return element;
            } else {
                element.setAttribute("value", this.toXMLString(value));
            }
            return element;
        } else {
            if (hideDefault || this.getDefaultValue() == null) return null;
            element.setAttribute("value", this.getDefaultValue().toString());
        }
        return element;
    }

    @Override
    public String getXML(String indent, String key, String value, boolean hideDefault) {
        if (value != null) {
            if (this.toString(value).equals(this.toString(this.getDefaultValue()))) {
                if (!hideDefault) {
                    return indent + "<parameter key=\"" + this.toXMLString(key) + "\"\tvalue=\"" + this.toXMLString(value) + "\"/>" + Tools.getLineSeparator();
                }
                return "";
            }
            return indent + "<parameter key=\"" + this.toXMLString(key) + "\"\tvalue=\"" + this.toXMLString(value) + "\"/>" + Tools.getLineSeparator();
        }
        if (!hideDefault && this.getDefaultValue() != null) {
            return indent + "<parameter key=\"" + this.toXMLString(key) + "\"\tvalue=\"" + this.toXMLString(this.getDefaultValue()) + "\"/>" + Tools.getLineSeparator();
        }
        return "";
    }

    public String toXMLString(String value) {
        return value;
    }

    @Override
    public String substituteMacros(String parameterValue, MacroHandler mh) {
        int startIndex = parameterValue.indexOf("%{");
        if (startIndex == -1) {
            return parameterValue;
        }
        try {
            StringBuffer result = new StringBuffer();
            while (startIndex >= 0) {
                result.append(parameterValue.substring(0, startIndex));
                int endIndex = parameterValue.indexOf("}", startIndex + 2);
                String macroString = parameterValue.substring(startIndex + 2, endIndex);
                String macroValue = mh.getMacro(macroString);
                if (macroValue != null) {
                    result.append(macroValue);
                } else {
                    result.append("%{" + macroString + "}");
                }
                parameterValue = parameterValue.substring(endIndex + 1);
                startIndex = parameterValue.indexOf("%{");
            }
            result.append(parameterValue);
            return result.toString();
        }
        catch (Exception e) {
            return parameterValue;
        }
    }
}

