/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.cipher.CipherException;
import com.rapidminer.tools.cipher.CipherTools;

public class ParameterTypePassword
extends ParameterTypeString {
    private static final long serialVersionUID = 384977559199162363L;

    public ParameterTypePassword(String key, String description) {
        super(key, description, true);
        this.setExpert(false);
    }

    @Override
    public String getRange() {
        return "password";
    }

    @Override
    public String transformNewValue(String value) {
        if (value == null) {
            return null;
        }
        return this.decryptPassword(value);
    }

    private String encryptPassword(String value) {
        if (CipherTools.isKeyAvailable()) {
            try {
                return CipherTools.encrypt(value);
            }
            catch (CipherException e) {
                LogService.getGlobal().logError("Cannot encrypt password, using non-encrypted password!");
                return value;
            }
        }
        return value;
    }

    private String decryptPassword(String value) {
        if (CipherTools.isKeyAvailable()) {
            try {
                return CipherTools.decrypt(value);
            }
            catch (CipherException e) {
                LogService.getRoot().warning("Password in XML file looks like unencrypted plain text.");
            }
        }
        return value;
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        return this.encryptPassword(super.toString(value));
    }

    @Override
    public String getXML(String indent, String key, String value, boolean hideDefault) {
        if (!(value == null || hideDefault && value.equals(this.getDefaultValue()))) {
            return indent + "<parameter key=\"" + key + "\"\tvalue=\"" + this.toXMLString(value) + "\"/>" + Tools.getLineSeparator();
        }
        return "";
    }

    @Override
    public String toXMLString(String value) {
        try {
            return CipherTools.encrypt(value);
        }
        catch (CipherException e) {
            LogService.getGlobal().logError("Cannot encrypt password, using non-encrypted password in XML!");
            return value;
        }
    }
}

