/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.MacroHandler;
import com.rapidminer.parameter.CombinedParameterType;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterTypeList
extends CombinedParameterType {
    private static final long serialVersionUID = -6101604413822993455L;
    private List<String[]> defaultList = new LinkedList<String[]>();
    private final ParameterType valueType;
    private final ParameterType keyType;

    @Deprecated
    public ParameterTypeList(String key, String description, ParameterType valueType) {
        this(key, description, valueType, new LinkedList<String[]>());
    }

    @Deprecated
    public ParameterTypeList(String key, String description, ParameterType valueType, List<String[]> defaultList) {
        super(key, description, new ParameterType[0]);
        this.defaultList = defaultList;
        this.valueType = valueType;
        this.keyType = new ParameterTypeString(key, description);
        if (valueType.getDescription() == null) {
            valueType.setDescription(description);
        }
    }

    public ParameterTypeList(String key, String description, ParameterType keyType, ParameterType valueType, boolean expert) {
        this(key, description, keyType, valueType, new LinkedList<String[]>());
        this.setExpert(expert);
    }

    public ParameterTypeList(String key, String description, ParameterType keyType, ParameterType valueType) {
        this(key, description, keyType, valueType, new LinkedList<String[]>());
    }

    public ParameterTypeList(String key, String description, ParameterType keyType, ParameterType valueType, List<String[]> defaultList, boolean expert) {
        this(key, description, keyType, valueType, defaultList);
        this.setExpert(expert);
    }

    public ParameterTypeList(String key, String description, ParameterType keyType, ParameterType valueType, List<String[]> defaultList) {
        super(key, description, keyType, valueType);
        this.defaultList = defaultList;
        this.valueType = valueType;
        this.keyType = keyType;
    }

    public ParameterType getValueType() {
        return this.valueType;
    }

    public ParameterType getKeyType() {
        return this.keyType;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultList;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultList = (List)defaultValue;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public Element getXML(String key, String value, boolean hideDefault, Document doc) {
        Element element = doc.createElement("list");
        element.setAttribute("key", key);
        List list = null;
        list = value != null ? ParameterTypeList.transformString2List(value) : (List)this.getDefaultValue();
        if (list != null) {
            for (Object object : list) {
                Object[] entry = (Object[])object;
                element.appendChild(this.valueType.getXML((String)entry[0], entry[1].toString(), false, doc));
            }
        }
        return element;
    }

    @Override
    @Deprecated
    public String getXML(String indent, String key, String value, boolean hideDefault) {
        StringBuffer result = new StringBuffer();
        result.append(indent + "<list key=\"" + key + "\">" + Tools.getLineSeparator());
        if (value != null) {
            List<String[]> list = Parameters.transformString2List(value);
            for (Object[] objectArray : list) {
                result.append(this.valueType.getXML(indent + "  ", (String)objectArray[0], objectArray[1].toString(), false));
            }
        } else {
            Object defaultValue = this.getDefaultValue();
            if (defaultValue != null) {
                List defaultList = (List)defaultValue;
                for (Object[] current : defaultList) {
                    result.append(this.valueType.getXML(indent + "  ", (String)current[0], current[1].toString(), false));
                }
            }
        }
        result.append(indent + "</list>" + Tools.getLineSeparator());
        return result.toString();
    }

    @Override
    public String getRange() {
        return "list";
    }

    @Override
    public String toString(Object value) {
        return ParameterTypeList.transformList2String((List)value);
    }

    public static String transformList2String(List<String[]> parameterList) {
        StringBuffer result = new StringBuffer();
        Iterator<String[]> i = parameterList.iterator();
        boolean first = true;
        while (i.hasNext()) {
            String[] objects = i.next();
            if (objects.length != 2) continue;
            String firstToken = objects[0];
            String secondToken = objects[1];
            if (!first) {
                result.append('\u241e');
            }
            if (secondToken != null) {
                if (firstToken != null) {
                    result.append(firstToken);
                }
                result.append('\u241d');
                if (secondToken != null) {
                    result.append(secondToken);
                }
            }
            first = false;
        }
        return result.toString();
    }

    public static List<String[]> transformString2List(String listString) {
        String[] splittedList;
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (String record : splittedList = listString.split(Character.valueOf('\u241e').toString())) {
            String[] pair;
            if (record.length() <= 0 || (pair = record.split(Character.valueOf('\u241d').toString())).length != 2 || pair[0].length() <= 0 || pair[1].length() <= 0) continue;
            result.add(new String[]{pair[0], pair[1]});
        }
        return result;
    }

    @Override
    public String notifyOperatorRenaming(String oldOperatorName, String newOperatorName, String parameterValue) {
        List<String[]> list = ParameterTypeList.transformString2List(parameterValue);
        for (String[] pair : list) {
            pair[0] = this.keyType.notifyOperatorRenaming(oldOperatorName, newOperatorName, pair[0]);
            pair[1] = this.valueType.notifyOperatorRenaming(oldOperatorName, newOperatorName, pair[1]);
        }
        return ParameterTypeList.transformList2String(list);
    }

    @Override
    public String substituteMacros(String parameterValue, MacroHandler mh) {
        if (parameterValue.indexOf("%{") == -1) {
            return parameterValue;
        }
        List<String[]> list = ParameterTypeList.transformString2List(parameterValue);
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (String[] entry : list) {
            result.add(new String[]{this.getKeyType().substituteMacros(entry[0], mh), this.getValueType().substituteMacros(entry[1], mh)});
        }
        return ParameterTypeList.transformList2String(result);
    }
}

