/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.MacroHandler;
import com.rapidminer.parameter.CombinedParameterType;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Tools;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterTypeEnumeration
extends CombinedParameterType {
    private static final long serialVersionUID = -3677952200700007724L;
    private static final char ESCAPE_CHAR = '\\';
    private static final char SEPERATOR_CHAR = ',';
    private static final char[] SPECIAL_CHARACTERS = new char[]{','};
    private Object defaultValue;
    private ParameterType type;

    public ParameterTypeEnumeration(String key, String description, ParameterType parameterType) {
        super(key, description, parameterType);
        this.type = parameterType;
    }

    public ParameterTypeEnumeration(String key, String description, ParameterType parameterType, boolean expert) {
        this(key, description, parameterType);
        this.setExpert(false);
    }

    @Override
    public Element getXML(String key, String value, boolean hideDefault, Document doc) {
        Element element = doc.createElement("enumeration");
        element.setAttribute("key", key);
        String[] list = null;
        list = value != null ? ParameterTypeEnumeration.transformString2Enumeration(value) : (String[])this.getDefaultValue();
        if (list != null) {
            for (String string : list) {
                element.appendChild(this.type.getXML(this.type.getKey(), string, false, doc));
            }
        }
        return element;
    }

    @Override
    @Deprecated
    public String getXML(String indent, String key, String value, boolean hideDefault) {
        return "";
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public String getRange() {
        return "enumeration";
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultValueAsString() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.getValueType().toString(this.defaultValue);
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ParameterType getValueType() {
        return this.type;
    }

    @Override
    public String notifyOperatorRenaming(String oldOperatorName, String newOperatorName, String parameterValue) {
        String[] enumeratedValues = ParameterTypeEnumeration.transformString2Enumeration(parameterValue);
        for (int i = 0; i < enumeratedValues.length; ++i) {
            enumeratedValues[i] = this.type.notifyOperatorRenaming(oldOperatorName, newOperatorName, enumeratedValues[i]);
        }
        return ParameterTypeEnumeration.transformEnumeration2String(Arrays.asList(enumeratedValues));
    }

    public static String transformEnumeration2String(List<String> list) {
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String string : list) {
            if (!isFirst) {
                builder.append(',');
            }
            if (string != null) {
                builder.append(Tools.escape(string, '\\', SPECIAL_CHARACTERS));
            }
            isFirst = false;
        }
        return builder.toString();
    }

    public static String[] transformString2Enumeration(String parameterValue) {
        if (parameterValue == null || "".equals(parameterValue)) {
            return new String[0];
        }
        List<String> split = Tools.unescape(parameterValue, '\\', SPECIAL_CHARACTERS, ',');
        return split.toArray(new String[split.size()]);
    }

    @Override
    public String substituteMacros(String parameterValue, MacroHandler mh) {
        if (parameterValue.indexOf("%{") == -1) {
            return parameterValue;
        }
        String[] list = ParameterTypeEnumeration.transformString2Enumeration(parameterValue);
        String[] result = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            result[i] = this.getValueType().substituteMacros(list[i], mh);
        }
        return ParameterTypeEnumeration.transformEnumeration2String(Arrays.asList(result));
    }
}

