/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeNumber;

public class ParameterTypeDouble
extends ParameterTypeNumber {
    private static final long serialVersionUID = 2455026868706964187L;
    private double defaultValue = Double.NaN;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private boolean noDefault = true;
    private boolean optional = true;

    public ParameterTypeDouble(String key, String description, double min, double max) {
        this(key, description, min, max, Double.NaN);
        this.noDefault = true;
        this.optional = false;
    }

    public ParameterTypeDouble(String key, String description, double min, double max, boolean optional) {
        this(key, description, min, max, Double.NaN);
        this.noDefault = true;
        this.optional = optional;
        if (!optional) {
            this.setExpert(false);
        }
    }

    public ParameterTypeDouble(String key, String description, double min, double max, double defaultValue) {
        super(key, description);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.optional = true;
        this.setExpert(false);
    }

    public ParameterTypeDouble(String key, String description, double min, double max, double defaultValue, boolean expert) {
        super(key, description);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.optional = true;
        this.setExpert(expert);
    }

    @Override
    public double getMinValue() {
        return this.min;
    }

    @Override
    public double getMaxValue() {
        return this.max;
    }

    @Override
    public boolean isOptional() {
        return super.isOptional() && this.optional;
    }

    @Override
    public Object getDefaultValue() {
        if (Double.isNaN(this.defaultValue)) {
            return null;
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object object) {
        this.defaultValue = (Double)object;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public String getRange() {
        String range = "real; ";
        range = this.min == Double.NEGATIVE_INFINITY ? range + "-\u221e" : range + this.min;
        range = range + "-";
        range = this.max == Double.POSITIVE_INFINITY ? range + "+\u221e" : range + this.max;
        if (!this.noDefault) {
            range = range + "; default: " + this.defaultValue;
        }
        return range;
    }
}

