/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.MacroHandler;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.ConfigurationWizardCreator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParameterTypeConfiguration
extends ParameterType {
    private static final long serialVersionUID = -3512071671355815277L;
    public static final String PARAMETER_DEFAULT_CONFIGURATION_NAME = "configure_operator";
    private Class<? extends ConfigurationWizardCreator> wizardCreatorClass;
    private transient ConfigurationListener wizardListener;
    private Map<String, String> parameters = null;
    public Object[] wizardConstructionArguments;

    public ParameterTypeConfiguration(Class<? extends ConfigurationWizardCreator> wizardCreatorClass, ConfigurationListener wizardListener) {
        this(wizardCreatorClass, null, wizardListener);
    }

    public ParameterTypeConfiguration(Class<? extends ConfigurationWizardCreator> wizardCreatorClass, Map<String, String> parameters, ConfigurationListener wizardListener) {
        this(wizardCreatorClass, parameters, wizardListener, null);
    }

    public ParameterTypeConfiguration(Class<? extends ConfigurationWizardCreator> wizardCreatorClass, Map<String, String> parameters, ConfigurationListener wizardListener, Object[] constructorArguments) {
        super(PARAMETER_DEFAULT_CONFIGURATION_NAME, "Configure this operator by means of a Wizard.");
        this.wizardCreatorClass = wizardCreatorClass;
        this.parameters = parameters;
        this.wizardListener = wizardListener;
        this.wizardConstructionArguments = constructorArguments;
    }

    public ConfigurationWizardCreator getWizardCreator() {
        ConfigurationWizardCreator creator = null;
        try {
            if (this.wizardConstructionArguments == null) {
                creator = this.wizardCreatorClass.newInstance();
            } else {
                Class[] classes = new Class[this.wizardConstructionArguments.length];
                for (int i = 0; i < classes.length; ++i) {
                    classes[i] = this.wizardConstructionArguments[i].getClass();
                }
                try {
                    for (Constructor<?> constructor : this.wizardCreatorClass.getConstructors()) {
                        boolean fits = true;
                        for (int i = 0; i < classes.length; ++i) {
                            Class<?>[] constructorParameter = constructor.getParameterTypes();
                            if (i < constructorParameter.length && constructorParameter[i].isAssignableFrom(classes[i])) continue;
                            fits = false;
                            break;
                        }
                        if (!fits) continue;
                        creator = (ConfigurationWizardCreator)constructor.newInstance(this.wizardConstructionArguments);
                        break;
                    }
                }
                catch (SecurityException e) {
                    creator = this.wizardCreatorClass.newInstance();
                }
                catch (IllegalArgumentException e) {
                    creator = this.wizardCreatorClass.newInstance();
                }
                catch (InvocationTargetException e) {
                    creator = this.wizardCreatorClass.newInstance();
                }
            }
            creator.setParameters(this.parameters);
        }
        catch (InstantiationException e) {
            LogService.getGlobal().log("Problem during creation of wizard: " + e.getMessage(), 5);
        }
        catch (IllegalAccessException e) {
            LogService.getGlobal().log("Problem during creation of wizard: " + e.getMessage(), 5);
        }
        return creator;
    }

    public ConfigurationListener getWizardListener() {
        return this.wizardListener;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public void setDefaultValue(Object value) {
    }

    @Override
    public String getRange() {
        return null;
    }

    @Override
    public String getXML(String indent, String key, String value, boolean hideDefault) {
        return "";
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public Element getXML(String key, String value, boolean hideDefault, Document doc) {
        return null;
    }

    @Override
    public String substituteMacros(String parameterValue, MacroHandler mh) {
        return parameterValue;
    }
}

