/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeSingle;

public class ParameterTypeChar
extends ParameterTypeSingle {
    private static final long serialVersionUID = 6451584265725535856L;
    private char defaultValue = '\u0000';
    private boolean optional = false;

    public ParameterTypeChar(String key, String description, boolean optional, boolean expert) {
        this(key, description, optional);
        this.setExpert(expert);
    }

    public ParameterTypeChar(String key, String description, boolean optional) {
        super(key, description);
        this.optional = optional;
        if (!optional) {
            this.setExpert(false);
        }
    }

    public ParameterTypeChar(String key, String description) {
        this(key, description, true);
    }

    public ParameterTypeChar(String key, String description, char defaultValue, boolean expert) {
        this(key, description, defaultValue);
        this.setExpert(expert);
    }

    public ParameterTypeChar(String key, String description, char defaultValue) {
        this(key, description);
        this.defaultValue = defaultValue;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    @Override
    public boolean isOptional() {
        return super.isOptional() && this.optional;
    }

    @Override
    public Object getDefaultValue() {
        return Character.valueOf(this.defaultValue);
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = ((String)defaultValue).charAt(0);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public String getRange() {
        return "char" + (this.defaultValue != '\u0000' ? "; default: '" + this.defaultValue + "'" : "");
    }
}

