/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeSingle;

public class ParameterTypeCategory
extends ParameterTypeSingle {
    private static final long serialVersionUID = 5747692587025691591L;
    private int defaultValue = 0;
    private String[] categories = new String[0];

    public ParameterTypeCategory(String key, String description, String[] categories, int defaultValue, boolean expert) {
        this(key, description, categories, defaultValue);
        this.setExpert(expert);
    }

    public ParameterTypeCategory(String key, String description, String[] categories, int defaultValue) {
        super(key, description);
        this.categories = categories;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isOptional() {
        return super.isOptional() || this.defaultValue != -1;
    }

    public int getDefault() {
        return this.defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue == -1) {
            return null;
        }
        return this.categories[this.defaultValue];
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = (Integer)defaultValue;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    public String getCategory(int index) {
        return this.categories[index];
    }

    public int getIndex(String string) {
        for (int i = 0; i < this.categories.length; ++i) {
            if (!this.categories[i].equals(string)) continue;
            return i;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public String toString(Object value) {
        try {
            if (value == null) {
                return null;
            }
            int index = Integer.parseInt(value.toString());
            if (index >= this.categories.length) {
                return "";
            }
            return super.toString(this.categories[index]);
        }
        catch (NumberFormatException e) {
            return super.toString(value);
        }
    }

    public String[] getValues() {
        return this.categories;
    }

    @Override
    public String getRange() {
        StringBuffer values = new StringBuffer();
        for (int i = 0; i < this.categories.length; ++i) {
            if (i > 0) {
                values.append(", ");
            }
            values.append(this.categories[i]);
        }
        return values.toString() + "; default: " + this.categories[this.defaultValue];
    }

    public int getNumberOfCategories() {
        return this.categories.length;
    }
}

