/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import java.util.Vector;

public class ParameterTypeAttributes
extends ParameterTypeString {
    private static final long serialVersionUID = -4177652183651031337L;
    private transient InputPort inPort;
    private int[] allowedValueTypes;

    public ParameterTypeAttributes(String key, String description, InputPort inPort) {
        this(key, description, inPort, true, 0);
    }

    public ParameterTypeAttributes(String key, String description, InputPort inPort, int ... valueTypes) {
        this(key, description, inPort, true, valueTypes);
    }

    public ParameterTypeAttributes(String key, String description, InputPort inPort, boolean optional) {
        this(key, description, inPort, optional, 0);
    }

    public ParameterTypeAttributes(String key, String description, InputPort inPort, boolean optional, int ... valueTypes) {
        super(key, description, optional);
        this.inPort = inPort;
        this.allowedValueTypes = valueTypes;
    }

    public ParameterTypeAttributes(String key, String description, InputPort inPort, boolean optional, boolean expert) {
        this(key, description, inPort, optional);
        this.setExpert(expert);
    }

    public Vector<String> getAttributeNames() {
        Vector<String> names = new Vector<String>();
        if (this.inPort != null && this.inPort.getMetaData() instanceof ExampleSetMetaData) {
            ExampleSetMetaData emd = (ExampleSetMetaData)this.inPort.getMetaData();
            for (AttributeMetaData amd : emd.getAllAttributes()) {
                if (!this.isOfAllowedType(amd.getValueType())) continue;
                names.add(amd.getName());
            }
        }
        return names;
    }

    private boolean isOfAllowedType(int valueType) {
        boolean isAllowed = false;
        for (int type : this.allowedValueTypes) {
            isAllowed |= Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, type);
        }
        return isAllowed;
    }
}

