/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ModelMetaData;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Ontology;
import java.util.Collections;
import java.util.Vector;

public class ParameterTypeAttribute
extends ParameterTypeString {
    private static final long serialVersionUID = -4177652183651031337L;
    private transient InputPort inPort;
    private int[] allowedValueTypes;

    public ParameterTypeAttribute(String key, String description, InputPort inPort) {
        this(key, description, inPort, false);
    }

    public ParameterTypeAttribute(String key, String description, InputPort inPort, int ... valueTypes) {
        this(key, description, inPort, false, valueTypes);
    }

    public ParameterTypeAttribute(String key, String description, InputPort inPort, boolean optional) {
        this(key, description, inPort, optional, 0);
    }

    public ParameterTypeAttribute(String key, String description, InputPort inPort, boolean optional, boolean expert) {
        this(key, description, inPort, optional, 0);
        this.setExpert(expert);
    }

    public ParameterTypeAttribute(String key, String description, InputPort inPort, boolean optional, boolean expert, int ... valueTypes) {
        this(key, description, inPort, optional, 0);
        this.setExpert(expert);
        this.allowedValueTypes = valueTypes;
    }

    public ParameterTypeAttribute(String key, String description, InputPort inPort, boolean optional, int ... valueTypes) {
        super(key, description, optional);
        this.inPort = inPort;
        this.allowedValueTypes = valueTypes;
    }

    public Vector<String> getAttributeNames() {
        Vector<String> names = new Vector<String>();
        Vector<String> regularNames = new Vector<String>();
        if (this.inPort != null) {
            ExampleSetMetaData emd;
            ModelMetaData mmd;
            if (this.inPort.getMetaData() instanceof ExampleSetMetaData) {
                ExampleSetMetaData emd2 = (ExampleSetMetaData)this.inPort.getMetaData();
                for (AttributeMetaData amd : emd2.getAllAttributes()) {
                    if (this.isFilteredOut(amd) || !this.isOfAllowedType(amd.getValueType())) continue;
                    if (amd.isSpecial()) {
                        names.add(amd.getName());
                        continue;
                    }
                    regularNames.add(amd.getName());
                }
            } else if (this.inPort.getMetaData() instanceof ModelMetaData && (mmd = (ModelMetaData)this.inPort.getMetaData()) != null && (emd = mmd.getTrainingSetMetaData()) != null) {
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    if (this.isFilteredOut(amd) || !this.isOfAllowedType(amd.getValueType())) continue;
                    if (amd.isSpecial()) {
                        names.add(amd.getName());
                        continue;
                    }
                    regularNames.add(amd.getName());
                }
            }
        }
        Collections.sort(names);
        Collections.sort(regularNames);
        names.addAll(regularNames);
        return names;
    }

    private boolean isOfAllowedType(int valueType) {
        boolean isAllowed = false;
        for (int type : this.allowedValueTypes) {
            isAllowed |= Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, type);
        }
        return isAllowed;
    }

    @Override
    public Object getDefaultValue() {
        return "";
    }

    protected boolean isFilteredOut(AttributeMetaData amd) {
        return false;
    }

    public InputPort getInputPort() {
        return this.inPort;
    }
}

