/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.MacroHandler;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ParameterType
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5296461242851710130L;
    private String key;
    private String description;
    private boolean expert = true;
    private boolean hidden = false;
    private boolean showRange = true;
    private final Collection<ParameterCondition> conditions = new LinkedList<ParameterCondition>();

    public ParameterType(String key, String description) {
        this.key = key;
        this.description = description;
    }

    public abstract Element getXML(String var1, String var2, boolean var3, Document var4);

    public abstract String getRange();

    public abstract Object getDefaultValue();

    public String getDefaultValueAsString() {
        return this.toString(this.getDefaultValue());
    }

    public abstract void setDefaultValue(Object var1);

    public abstract boolean isNumerical();

    @Deprecated
    public abstract String getXML(String var1, String var2, String var3, boolean var4);

    public boolean showRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
    }

    public String transformNewValue(String value) {
        return value;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isHidden() {
        boolean conditionsMet = true;
        for (ParameterCondition condition : this.conditions) {
            conditionsMet &= condition.dependencyMet();
        }
        return this.hidden || !conditionsMet;
    }

    public Collection<ParameterCondition> getConditions() {
        return Collections.unmodifiableCollection(this.conditions);
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setDeprecated() {
        this.setHidden(true);
    }

    public void registerDependencyCondition(ParameterCondition condition) {
        this.conditions.add(condition);
    }

    public Collection<ParameterCondition> getDependencyConditions() {
        return this.conditions;
    }

    public boolean isOptional() {
        boolean becomeMandatory = false;
        for (ParameterCondition condition : this.conditions) {
            if (condition.dependencyMet()) {
                becomeMandatory |= condition.becomeMandatory();
                continue;
            }
            return true;
        }
        return !becomeMandatory;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String notifyOperatorRenaming(String oldOperatorName, String newOperatorName, String parameterValue) {
        return parameterValue;
    }

    public String toString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String toXMLString(Object value) {
        return Tools.escapeXML(this.toString(value));
    }

    public String toString() {
        return this.key + " (" + this.description + ")";
    }

    public void illegalValue(Object illegal, Object corrected) {
        LogService.getGlobal().log("Illegal value '" + illegal + "' for parameter '" + this.key + "' has been corrected to '" + corrected.toString() + "'.", 5);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ParameterType)) {
            return 0;
        }
        return this.key.compareTo(((ParameterType)o).key);
    }

    public abstract String substituteMacros(String var1, MacroHandler var2);
}

