/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class TransitionMatrixOperator
extends Operator {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort matrixOutput = (OutputPort)this.getOutputPorts().createPort("transition matrix");

    public TransitionMatrixOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE), 1, new String[0]));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addGenerationRule(this.matrixOutput, NumericalMatrix.class);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE));
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 119, attribute.getName(), "TransitionMatrix");
        }
        TreeSet<String> values = new TreeSet<String>();
        HashMap<Tupel<String, String>, Integer> transitions = new HashMap<Tupel<String, String>, Integer>();
        int numberOfTransitions = exampleSet.size() - 1;
        String lastValue = null;
        for (Example example : exampleSet) {
            String currentValue = example.getNominalValue(attribute);
            values.add(currentValue);
            if (lastValue != null) {
                Tupel<String, String> currentTupel = new Tupel<String, String>(lastValue, currentValue);
                if (transitions.containsKey(currentTupel)) {
                    transitions.put(currentTupel, (Integer)transitions.get(currentTupel) + 1);
                } else {
                    transitions.put(currentTupel, 1);
                }
            }
            lastValue = currentValue;
        }
        String[] valueArray = values.toArray(new String[0]);
        HashMap<String, Integer> valuePositions = new HashMap<String, Integer>();
        int i = 0;
        for (String value : valueArray) {
            valuePositions.put(value, i);
            ++i;
        }
        NumericalMatrix matrix = new NumericalMatrix("Transition", valueArray, false);
        for (Map.Entry entry : transitions.entrySet()) {
            matrix.setValue((Integer)valuePositions.get(((Tupel)entry.getKey()).getFirst()), (Integer)valuePositions.get(((Tupel)entry.getKey()).getSecond()), (double)((Integer)entry.getValue()).intValue() / (double)numberOfTransitions);
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.matrixOutput.deliver(matrix);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE, "Specifies the nominal attribute.", this.exampleSetInput, false, false, 1));
        return types;
    }
}

