/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.ExampleVisualizer;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.visualization.dependencies.TransitionGraph;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.ObjectVisualizerService;
import java.util.List;

public class TransitionGraphOperator
extends Operator {
    public static final String PARAMETER_SOURCE_ATTRIBUTE = "source_attribute";
    public static final String PARAMETER_TARGET_ATTRIBUTE = "target_attribute";
    public static final String PARAMETER_STRENGTH_ATTRIBUTE = "strength_attribute";
    public static final String PARAMETER_TYPE_ATTRIBUTE = "type_attribute";
    public static final String PARAMETER_NODE_DESCRIPTION = "node_description";
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort graphOutput = (OutputPort)this.getOutputPorts().createPort("transition graph");

    public TransitionGraphOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_SOURCE_ATTRIBUTE, PARAMETER_STRENGTH_ATTRIBUTE, PARAMETER_TARGET_ATTRIBUTE, PARAMETER_TYPE_ATTRIBUTE), new String[0]));
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, "id", 0));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.graphOutput, TransitionGraph.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        TransitionGraph transitionGraph = this.createTransitionGraph(exampleSet);
        ObjectVisualizerService.addObjectVisualizer(transitionGraph, new ExampleVisualizer(exampleSet));
        this.exampleSetOutput.deliver(exampleSet);
        this.graphOutput.deliver(transitionGraph);
    }

    public TransitionGraph createTransitionGraph(ExampleSet exampleSet) throws UndefinedParameterError, UserError {
        Tools.checkIds(exampleSet);
        String sourceAttribute = this.getParameterAsString(PARAMETER_SOURCE_ATTRIBUTE);
        if (exampleSet.getAttributes().get(sourceAttribute) == null) {
            throw new UserError((Operator)this, 111, sourceAttribute);
        }
        String targetAttribute = this.getParameterAsString(PARAMETER_TARGET_ATTRIBUTE);
        if (exampleSet.getAttributes().get(targetAttribute) == null) {
            throw new UserError((Operator)this, 111, targetAttribute);
        }
        String strengthAttribute = null;
        if (this.isParameterSet(PARAMETER_STRENGTH_ATTRIBUTE)) {
            strengthAttribute = this.getParameterAsString(PARAMETER_STRENGTH_ATTRIBUTE);
        }
        if (strengthAttribute != null && strengthAttribute.length() > 0) {
            if (exampleSet.getAttributes().get(strengthAttribute) == null) {
                throw new UserError((Operator)this, 111, strengthAttribute);
            }
            if (!exampleSet.getAttributes().get(strengthAttribute).isNumerical()) {
                throw new UserError((Operator)this, 144, strengthAttribute, this.getName());
            }
        }
        String typeAttribute = null;
        if (this.isParameterSet(PARAMETER_TYPE_ATTRIBUTE)) {
            typeAttribute = this.getParameterAsString(PARAMETER_TYPE_ATTRIBUTE);
        }
        if (typeAttribute != null && typeAttribute.length() > 0 && exampleSet.getAttributes().get(typeAttribute) == null) {
            throw new UserError((Operator)this, 111, typeAttribute);
        }
        String nodeDescription = null;
        if (this.isParameterSet(PARAMETER_NODE_DESCRIPTION)) {
            nodeDescription = this.getParameterAsString(PARAMETER_NODE_DESCRIPTION);
        }
        TransitionGraph transitionGraph = new TransitionGraph(exampleSet, sourceAttribute, targetAttribute, strengthAttribute, typeAttribute, nodeDescription);
        return transitionGraph;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_SOURCE_ATTRIBUTE, "The name of the attribute defining the sources of the transitions.", this.exampleSetInput, false));
        types.add(new ParameterTypeAttribute(PARAMETER_TARGET_ATTRIBUTE, "The name of the attribute defining the targets of the transitions.", this.exampleSetInput, false));
        types.add(new ParameterTypeAttribute(PARAMETER_STRENGTH_ATTRIBUTE, "The name of the attribute defining the strength of the transitions.", this.exampleSetInput, true));
        types.add(new ParameterTypeAttribute(PARAMETER_TYPE_ATTRIBUTE, "The name of the attribute defining the type of the transitions.", this.exampleSetInput, true));
        types.add(new ParameterTypeString(PARAMETER_NODE_DESCRIPTION, "The description of each node where columns from the example data can be used by the macro form %{COLUMN_NAME}."));
        return types;
    }
}

