/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.operator.visualization.dependencies.RainflowMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RainflowMatrixOperator
extends Operator {
    public static final String PARAMETER_ATTRIBUTE = "attribute";
    public static final String PARAMETER_SYMMETRICAL_MATRIX = "symmetrical_matrix";
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort matrixOutput = (OutputPort)this.getOutputPorts().createPort("transition matrix");

    public RainflowMatrixOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE), 1, new String[0]));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addGenerationRule(this.matrixOutput, NumericalMatrix.class);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        String attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE);
        Attribute attribute = exampleSet.getAttributes().get(attributeName);
        if (attribute == null) {
            throw new UserError((Operator)this, 111, attributeName);
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 103, "calculation of the Rainflow Matrix", attributeName);
        }
        ArrayList<String> values = new ArrayList<String>(exampleSet.size());
        for (Example example : exampleSet) {
            if (Double.isNaN(example.getValue(attribute))) continue;
            values.add(example.getNominalValue(attribute));
        }
        this.removeNonExtrema(values);
        LinkedList<String> allNames = new LinkedList<String>();
        for (String name : attribute.getMapping().getValues()) {
            allNames.add(name);
        }
        String[] columnNames = new String[allNames.size()];
        allNames.toArray(columnNames);
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnNames.length; ++i) {
            indexMap.put(columnNames[i], i);
        }
        double[][] counts = this.createRainflowCounts(values, indexMap);
        boolean symmetrical = this.getParameterAsBoolean(PARAMETER_SYMMETRICAL_MATRIX);
        if (symmetrical) {
            for (int x = 1; x < counts.length - 1; ++x) {
                for (int y = 1; y < counts[x].length - 1; ++y) {
                    double[] dArray = counts[y];
                    int n = x;
                    dArray[n] = dArray[n] + counts[x][y];
                    counts[x][y] = 0.0;
                }
            }
        }
        Matrix matrix = new Matrix(counts);
        String[] residuals = new String[values.size()];
        values.toArray(residuals);
        RainflowMatrix rainflowMatrix = new RainflowMatrix("Rainflow Matrix", columnNames, matrix, symmetrical, residuals);
        rainflowMatrix.setFirstAttributeName("From Value");
        rainflowMatrix.setSecondAttributeName("To Value");
        this.exampleSetOutput.deliver(exampleSet);
        this.matrixOutput.deliver(rainflowMatrix);
    }

    private double[][] createRainflowCounts(List<String> values, Map<String, Integer> indexMap) {
        double[][] counts = new double[indexMap.size()][indexMap.size()];
        int currentIndex = 4;
        while (currentIndex < values.size()) {
            boolean betweenDecreasing;
            String value1 = values.get(currentIndex - 4);
            String value2 = values.get(currentIndex - 3);
            String value3 = values.get(currentIndex - 2);
            String value4 = values.get(currentIndex - 1);
            boolean betweenIncreasing = value2.compareTo(value1) >= 0 && value2.compareTo(value4) <= 0 && value3.compareTo(value1) >= 0 && value3.compareTo(value4) <= 0;
            boolean bl = betweenDecreasing = value2.compareTo(value1) <= 0 && value2.compareTo(value4) >= 0 && value3.compareTo(value1) <= 0 && value3.compareTo(value4) >= 0;
            if (betweenIncreasing || betweenDecreasing) {
                int fromIndex = indexMap.get(value2);
                int toIndex = indexMap.get(value3);
                counts[fromIndex][toIndex] = counts[fromIndex][toIndex] + 1.0;
                values.remove(currentIndex - 2);
                values.remove(currentIndex - 3);
                currentIndex = 4;
                continue;
            }
            ++currentIndex;
        }
        return counts;
    }

    private void removeNonExtrema(List<String> values) {
        for (int i = values.size() - 2; i >= 1; --i) {
            boolean localMaximum;
            String currentValue = values.get(i);
            String beforeValue = values.get(i - 1);
            String afterValue = values.get(i + 1);
            boolean localMinimum = beforeValue.compareTo(currentValue) > 0 && afterValue.compareTo(currentValue) > 0;
            boolean bl = localMaximum = beforeValue.compareTo(currentValue) < 0 && afterValue.compareTo(currentValue) < 0;
            if (localMinimum || localMaximum) continue;
            values.remove(i);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE, "Indicates which attribute should be used as a base for the calculation of the Rainflow matrix.", this.exampleSetInput, false, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_SYMMETRICAL_MATRIX, "Indicates if the symmetrical matrix should be calculated.", false));
        return types;
    }
}

