/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;

public class RainflowMatrix
extends NumericalMatrix {
    private static final long serialVersionUID = -2316260417823285606L;
    private String[] residuals;

    public RainflowMatrix(String name, String[] columnNames, Matrix matrix, boolean symmetrical, String[] residuals) {
        super(name, columnNames, matrix, symmetrical);
        this.residuals = residuals;
    }

    public SimpleDataTable createResidualTable() {
        SimpleDataTable residualTable = new SimpleDataTable("Rainflow Matrix Residuals", new String[]{"Residual Index", "Residual Class"});
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            residualTable.mapString(1, this.getColumnName(i));
        }
        int index = 1;
        for (String residual : this.residuals) {
            residualTable.add(new SimpleDataTableRow(new double[]{index++, residualTable.mapString(1, residual)}));
        }
        return residualTable;
    }
}

