/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTablePairwiseMatrixExtractionAdapter;
import com.rapidminer.datatable.DataTableSymmetricalMatrixAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Tools;
import java.text.NumberFormat;

public class NumericalMatrix
extends ResultObjectAdapter {
    private static final long serialVersionUID = -5498982791125720765L;
    private static final int MAX_NUMBER_OF_RESULT_STRING_ATTRIBUTES = 20;
    private Matrix matrix;
    private String[] columnNames;
    private String[] rowNames;
    private NumberFormat formatter;
    private String name;
    private boolean symmetrical = false;
    private String firstAttributeName = "First Attribute";
    private String secondAttributeName = "Second Attribute";

    public NumericalMatrix(String name, String[] columnNames, boolean symmetrical) {
        this(name, columnNames, new Matrix(columnNames.length, columnNames.length), symmetrical);
    }

    public NumericalMatrix(String name, String[] columnNames, Matrix matrix, boolean symmetrical) {
        this.name = name;
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.columnNames = columnNames;
        this.rowNames = columnNames;
        this.matrix = matrix;
        this.symmetrical = symmetrical;
    }

    public NumericalMatrix(String name, String[] rowNames, String[] columnNames, Matrix matrix) {
        this.name = name;
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        this.matrix = matrix;
        this.symmetrical = false;
    }

    public NumericalMatrix(String name, ExampleSet exampleSet, boolean symmetrical) {
        this(name, NumericalMatrix.getColumnNames(exampleSet), symmetrical);
    }

    public void setFirstAttributeName(String firstAttributeName) {
        this.firstAttributeName = firstAttributeName;
    }

    public void setSecondAttributeName(String secondAttributeName) {
        this.secondAttributeName = secondAttributeName;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public String getRowName(int index) {
        return this.rowNames[index];
    }

    private static String[] getColumnNames(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeNames[counter++] = attribute.getName();
        }
        return attributeNames;
    }

    public void setValue(int i, int j, double value) {
        this.matrix.set(i, j, value);
        if (this.symmetrical) {
            this.matrix.set(j, i, value);
        }
    }

    public double getValue(int i, int j) {
        return this.matrix.get(i, j);
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public int getNumberOfColumns() {
        return this.columnNames.length;
    }

    public int getNumberOfRows() {
        return this.rowNames.length;
    }

    @Override
    public String getName() {
        return this.name + " Matrix";
    }

    public DataTable createMatrixDataTable() {
        return new DataTableSymmetricalMatrixAdapter(this, this.name, this.columnNames);
    }

    public DataTable createPairwiseDataTable() {
        return new DataTablePairwiseMatrixExtractionAdapter(this, this.rowNames, this.columnNames, new String[]{this.firstAttributeName, this.secondAttributeName, this.name});
    }

    public String getExtension() {
        return "mat";
    }

    public String getFileDescription() {
        return this.name.toLowerCase() + " matrix";
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer(this.name + " Matrix (" + this.matrix.getRowDimension() + " rows, " + this.matrix.getColumnDimension() + " columns):" + Tools.getLineSeparator());
        for (i = 0; i < this.columnNames.length; ++i) {
            if (i >= 20) {
                result.append("...");
                break;
            }
            result.append("\t" + this.columnNames[i]);
        }
        block1: for (i = 0; i < this.matrix.getRowDimension(); ++i) {
            if (i < 20) {
                result.append(Tools.getLineSeparator() + this.columnNames[i]);
                for (int j = 0; j < this.matrix.getColumnDimension(); ++j) {
                    if (j >= 20) {
                        result.append("...");
                        continue block1;
                    }
                    result.append("\t" + this.formatter.format(this.matrix.get(i, j)));
                }
                continue;
            }
            result.append(Tools.getLineSeparator() + "...");
            break;
        }
        return result.toString();
    }
}

