/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.discretization.BinDiscretization;
import com.rapidminer.operator.visualization.dependencies.AbstractPairwiseMatrixOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.MathFunctions;
import java.util.List;

public class MutualInformationMatrixOperator
extends AbstractPairwiseMatrixOperator {
    public MutualInformationMatrixOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected ExampleSet performPreprocessing(ExampleSet eSet) throws OperatorException {
        try {
            PreprocessingOperator discretizationOperator = OperatorService.createOperator(BinDiscretization.class);
            discretizationOperator.setParameter("number_of_bins", this.getParameterAsInt("number_of_bins") + "");
            discretizationOperator.setParameter("create_view", "true");
            return discretizationOperator.doWork((ExampleSet)eSet.clone());
        }
        catch (OperatorCreationException e) {
            throw new OperatorException(this.getName() + ": Cannot create discretization operator (" + e + ").");
        }
    }

    @Override
    public String getMatrixName() {
        return "Mutual Information";
    }

    @Override
    public double getMatrixValue(ExampleSet exampleSet, Attribute firstAttribute, Attribute secondAttribute) {
        double[] firstProbabilites = new double[firstAttribute.getMapping().size()];
        double[] secondProbabilites = new double[secondAttribute.getMapping().size()];
        double[][] jointProbabilities = new double[firstAttribute.getMapping().size()][secondAttribute.getMapping().size()];
        double firstCounter = 0.0;
        double secondCounter = 0.0;
        double firstSecondCounter = 0.0;
        for (Example example : exampleSet) {
            double secondValue;
            double firstValue = example.getValue(firstAttribute);
            if (!Double.isNaN(firstValue)) {
                int n = (int)firstValue;
                firstProbabilites[n] = firstProbabilites[n] + 1.0;
                firstCounter += 1.0;
            }
            if (!Double.isNaN(secondValue = example.getValue(secondAttribute))) {
                int n = (int)secondValue;
                secondProbabilites[n] = secondProbabilites[n] + 1.0;
                secondCounter += 1.0;
            }
            if (Double.isNaN(firstValue) || Double.isNaN(secondValue)) continue;
            double[] dArray = jointProbabilities[(int)firstValue];
            int n = (int)secondValue;
            dArray[n] = dArray[n] + 1.0;
            firstSecondCounter += 1.0;
        }
        int i = 0;
        while (i < firstProbabilites.length) {
            int n = i++;
            firstProbabilites[n] = firstProbabilites[n] / firstCounter;
        }
        i = 0;
        while (i < secondProbabilites.length) {
            int n = i++;
            secondProbabilites[n] = secondProbabilites[n] / secondCounter;
        }
        for (i = 0; i < jointProbabilities.length; ++i) {
            int j = 0;
            while (j < jointProbabilities[i].length) {
                double[] dArray = jointProbabilities[i];
                int n = j++;
                dArray[n] = dArray[n] / firstSecondCounter;
            }
        }
        double firstEntropy = 0.0;
        for (int i2 = 0; i2 < firstProbabilites.length; ++i2) {
            if (!(firstProbabilites[i2] > 0.0)) continue;
            firstEntropy += firstProbabilites[i2] * MathFunctions.ld(firstProbabilites[i2]);
        }
        firstEntropy *= -1.0;
        double secondEntropy = 0.0;
        for (int i3 = 0; i3 < secondProbabilites.length; ++i3) {
            if (!(secondProbabilites[i3] > 0.0)) continue;
            secondEntropy += secondProbabilites[i3] * MathFunctions.ld(secondProbabilites[i3]);
        }
        secondEntropy *= -1.0;
        double jointEntropy = 0.0;
        for (int i4 = 0; i4 < jointProbabilities.length; ++i4) {
            for (int j = 0; j < jointProbabilities[i4].length; ++j) {
                if (!(jointProbabilities[i4][j] > 0.0)) continue;
                jointEntropy += jointProbabilities[i4][j] * MathFunctions.ld(jointProbabilities[i4][j]);
            }
        }
        return firstEntropy + secondEntropy - (jointEntropy *= -1.0);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt("number_of_bins", "Indicates the number of bins used for numerical attributes.", 2, Integer.MAX_VALUE, 10));
        return types;
    }
}

