/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.SimpleMetaDataError;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.matrix.CovarianceMatrix;

public class CovarianceMatrixOperator
extends Operator {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort covarianceOutput = (OutputPort)this.getOutputPorts().createPort("covariance");

    public CovarianceMatrixOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput){

            @Override
            public void makeAdditionalChecks(ExampleSetMetaData emd) throws UndefinedParameterError {
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    if (amd.isSpecial() || amd.isNumerical()) continue;
                    CovarianceMatrixOperator.this.exampleSetInput.addError(new SimpleMetaDataError(ProcessSetupError.Severity.WARNING, (Port)CovarianceMatrixOperator.this.exampleSetInput, "not_defined_on_nominal", "Covariance"));
                    break;
                }
                super.makeAdditionalChecks(emd);
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addGenerationRule(this.covarianceOutput, NumericalMatrix.class);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        String[] columnNames = new String[exampleSet.getAttributes().size()];
        boolean[] isNominal = new boolean[columnNames.length];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            columnNames[counter++] = attribute.getName();
            if (!attribute.isNominal()) continue;
            isNominal[counter] = true;
        }
        Matrix covarianceMatrix = CovarianceMatrix.getCovarianceMatrix(exampleSet);
        double[][] matrix = covarianceMatrix.getArray();
        for (int i = 0; i < covarianceMatrix.getColumnDimension(); ++i) {
            for (int j = 0; j < covarianceMatrix.getRowDimension(); ++j) {
                if (!isNominal[i] && !isNominal[j]) continue;
                matrix[i][j] = Double.NaN;
            }
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.covarianceOutput.deliver(new NumericalMatrix("Covariance", columnNames, covarianceMatrix, true));
    }
}

