/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.math.MathFunctions;
import java.util.List;

public class CorrelationMatrixOperator
extends Operator {
    public static final String PARAMETER_CREATE_WEIGHTS = "create_weights";
    public static final String PARAMETER_NORMALIZE_WEIGHTS = "normalize_weights";
    public static final String PARAMETER_SQUARED_CORRELATION = "squared_correlation";
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort matrixOutput = (OutputPort)this.getOutputPorts().createPort("matrix");
    private OutputPort weightsOutput = (OutputPort)this.getOutputPorts().createPort("weights");

    public CorrelationMatrixOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.matrixOutput, NumericalMatrix.class));
        this.getTransformer().addRule(new GenerateNewMDRule(this.weightsOutput, AttributeWeights.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        NumericalMatrix matrix = new NumericalMatrix("Correlation", exampleSet, true);
        int numberOfAttributes = exampleSet.getAttributes().size();
        boolean squared = this.getParameterAsBoolean(PARAMETER_SQUARED_CORRELATION);
        boolean createWeights = this.getParameterAsBoolean(PARAMETER_CREATE_WEIGHTS);
        boolean normalizeWeights = this.getParameterAsBoolean(PARAMETER_NORMALIZE_WEIGHTS);
        int k = 0;
        for (Attribute firstAttribute : exampleSet.getAttributes()) {
            int l = 0;
            for (Attribute secondAttribute : exampleSet.getAttributes()) {
                matrix.setValue(k, l, MathFunctions.correlation(exampleSet, firstAttribute, secondAttribute, squared || createWeights));
                this.checkForStop();
                ++l;
            }
            ++k;
        }
        AttributeWeights weights = new AttributeWeights();
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            double sum = 0.0;
            for (int j = 0; j < numberOfAttributes; ++j) {
                sum += 1.0 - matrix.getValue(i, j);
            }
            weights.setWeight(attribute.getName(), sum / (double)numberOfAttributes);
            ++i;
        }
        if (normalizeWeights) {
            weights.normalize();
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.weightsOutput.deliver(weights);
        this.matrixOutput.deliver(matrix);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_CREATE_WEIGHTS, "Indicates if attribute weights based on correlation should be calculated or if the complete matrix should be returned.", false);
        type.setExpert(false);
        type.setHidden(true);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE_WEIGHTS, "Indicates if the attributes weights should be normalized.", true, false));
        types.add(new ParameterTypeBoolean(PARAMETER_SQUARED_CORRELATION, "Indicates if the squared correlation should be calculated.", false, false));
        return types;
    }
}

