/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;

public abstract class AbstractPairwiseMatrixOperator
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort matrixOutput = (OutputPort)this.getOutputPorts().createPort("matrix");

    public AbstractPairwiseMatrixOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addGenerationRule(this.matrixOutput, NumericalMatrix.class);
    }

    public abstract String getMatrixName();

    public abstract double getMatrixValue(ExampleSet var1, Attribute var2, Attribute var3);

    protected ExampleSet performPreprocessing(ExampleSet exampleSet) throws OperatorException {
        return exampleSet;
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.exampleSetInput.getData();
        ExampleSet exampleSet = this.performPreprocessing(eSet);
        NumericalMatrix matrix = new NumericalMatrix(this.getMatrixName(), exampleSet, true);
        int k = 0;
        for (Attribute firstAttribute : exampleSet.getAttributes()) {
            int l = 0;
            for (Attribute secondAttribute : exampleSet.getAttributes()) {
                matrix.setValue(k, l, this.getMatrixValue(exampleSet, firstAttribute, secondAttribute));
                this.checkForStop();
                ++l;
            }
            ++k;
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.matrixOutput.deliver(matrix);
    }
}

