/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.NonSpecialAttributesExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.preprocessing.transformation.GroupedANOVAOperator;
import com.rapidminer.operator.visualization.dependencies.ANOVAMatrix;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.SignificanceTestResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ANOVAMatrixOperator
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", new ExampleSetMetaData());
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort anovaOutput = (OutputPort)this.getOutputPorts().createPort("anova");

    public ANOVAMatrixOperator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput){

            @Override
            public void makeAdditionalChecks(ExampleSetMetaData emd) throws UndefinedParameterError {
                int numberOfNominals = 0;
                for (AttributeMetaData amd : emd.getAllAttributes()) {
                    if (!amd.isNominal()) continue;
                    ++numberOfNominals;
                }
                if (numberOfNominals == 0) {
                    this.createError(ProcessSetupError.Severity.WARNING, "exampleset.must_contain_nominal_attribute", new Object[0]);
                }
            }
        });
        this.getTransformer().addRule(new PassThroughRule(this.exampleSetInput, this.exampleSetOutput, false));
        this.getTransformer().addRule(new GenerateNewMDRule(this.anovaOutput, ANOVAMatrix.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet inputSet = (ExampleSet)this.exampleSetInput.getData();
        NonSpecialAttributesExampleSet exampleSet = new NonSpecialAttributesExampleSet(inputSet);
        ArrayList<String> nominalAttributes = new ArrayList<String>();
        ArrayList<String> numericalAttributes = new ArrayList<String>();
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            if (attribute.isNominal()) {
                nominalAttributes.add(attribute.getName());
                continue;
            }
            if (!attribute.isNumerical()) continue;
            numericalAttributes.add(attribute.getName());
        }
        GroupedANOVAOperator groupedAnovaOperator = null;
        try {
            groupedAnovaOperator = OperatorService.createOperator(GroupedANOVAOperator.class);
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 109, GroupedANOVAOperator.class.getName());
        }
        double significanceLevel = this.getParameterAsDouble("significance_level");
        groupedAnovaOperator.setParameter("significance_level", significanceLevel + "");
        groupedAnovaOperator.setParameter("only_distinct", this.getParameterAsBoolean("only_distinct") + "");
        double[][] probabilities = new double[numericalAttributes.size()][nominalAttributes.size()];
        for (int numericalCounter = 0; numericalCounter < probabilities.length; ++numericalCounter) {
            String numericalAttributeName = (String)numericalAttributes.get(numericalCounter);
            for (int nominalCounter = 0; nominalCounter < probabilities[numericalCounter].length; ++nominalCounter) {
                String nominalAttributeName = (String)nominalAttributes.get(nominalCounter);
                groupedAnovaOperator.setParameter("anova_attribute", numericalAttributeName);
                groupedAnovaOperator.setParameter("group_by_attribute", nominalAttributeName);
                SignificanceTestResult testResult = groupedAnovaOperator.apply((ExampleSet)exampleSet.clone());
                probabilities[numericalCounter][nominalCounter] = testResult.getProbability();
            }
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.anovaOutput.deliver(new ANOVAMatrix(probabilities, numericalAttributes, nominalAttributes, significanceLevel));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("significance_level", "The significance level for the ANOVA calculation.", 0.0, 1.0, 0.05));
        types.add(new ParameterTypeBoolean("only_distinct", "Indicates if only rows with distinct values for the aggregation attribute should be used for the calculation of the aggregation function.", false));
        return types;
    }
}

