/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;

public class SOMModelVisualization
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPort modelInput = this.getInputPorts().createPort("model", Model.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private OutputPort visualizationOutput = (OutputPort)this.getOutputPorts().createPort("visualization");

    public SOMModelVisualization(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Model model = (Model)this.modelInput.getData();
        this.exampleSetOutput.deliver(exampleSet);
        this.modelOutput.deliver(model);
        this.visualizationOutput.deliver(new SOMModelVisualizationResult(exampleSet, model));
    }

    public static class SOMModelVisualizationResult
    extends ResultObjectAdapter {
        private static final long serialVersionUID = -6250201023324000922L;
        private ExampleSet exampleSet;
        private Model model;

        public SOMModelVisualizationResult(ExampleSet exampleSet, Model model) {
            this.exampleSet = exampleSet;
            this.model = model;
        }

        @Override
        public String getName() {
            return "ModelVisualization";
        }

        public ExampleSet getExampleSet() {
            return this.exampleSet;
        }

        public Model getModel() {
            return this.model;
        }
    }
}

