/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.gui.plotter.som.SOMClassColorizer;
import com.rapidminer.gui.plotter.som.SOMMatrixColorizer;
import com.rapidminer.gui.plotter.som.SOMPlotter;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.LogService;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SOMModelPlotter
extends SOMPlotter {
    private static final long serialVersionUID = 1L;
    private Model model;
    private ExampleSet exampleSet;
    private double[][] classificationMatrix;
    private float alphaLevel = 0.5f;
    private transient BufferedImage classImage;
    private transient SOMMatrixColorizer colorizer;
    private int lastPlotterComponentIndex;

    public SOMModelPlotter(PlotterConfigurationModel settings) {
        super(settings);
    }

    public SOMModelPlotter(PlotterConfigurationModel settings, ExampleSet exampleSet, Model model) {
        super(settings);
        this.model = model;
        this.exampleSet = exampleSet;
        this.colorizer = new SOMClassColorizer(exampleSet.getAttributes().getLabel().getMapping().size());
    }

    public void setExampleSet(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        this.colorizer = new SOMClassColorizer(exampleSet.getAttributes().getLabel().getMapping().size());
    }

    public void setModel(Model model) {
        this.model = model;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.show) {
            Graphics2D g = (Graphics2D)graphics;
            int pixWidth = this.getWidth() - 40;
            int pixHeight = this.getHeight() - 40;
            g.drawImage(this.image, 20, 20, pixWidth, pixHeight, Color.WHITE, null);
            g.setComposite(AlphaComposite.getInstance(3, this.alphaLevel));
            g.drawImage(this.classImage, 20, 20, pixWidth, pixHeight, Color.WHITE, null);
            g.setComposite(AlphaComposite.getInstance(3, 1.0f));
            this.drawPoints(g);
            this.drawLegend(graphics, this.dataTable, this.colorColumn);
            this.drawToolTip((Graphics2D)graphics);
        }
    }

    @Override
    protected void createMatrices() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.exampleSet.getAttributes().size());
        for (Attribute attribute : this.exampleSet.getAttributes()) {
            attributes.add((Attribute)attribute.clone());
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (int x = 0; x < this.dimensions[0]; ++x) {
            int y = 0;
            while (y < this.dimensions[1]) {
                DoubleArrayDataRow row = new DoubleArrayDataRow(this.net.getNodeWeights(new int[]{x, y++}));
                table.addDataRow(row);
            }
        }
        ExampleSet set = table.createExampleSet();
        this.classificationMatrix = new double[this.dimensions[0]][this.dimensions[1]];
        try {
            set = this.model.apply(set);
            Iterator exampleIterator = set.iterator();
            for (int x = 0; x < this.dimensions[0]; ++x) {
                for (int y = 0; y < this.dimensions[1]; ++y) {
                    Example example = (Example)exampleIterator.next();
                    this.classificationMatrix[x][y] = example.getValue(example.getAttributes().getPredictedLabel());
                }
            }
        }
        catch (OperatorException e) {
            LogService.getGlobal().log("Cannot use Model for prediction of node label: " + e.getMessage(), 5);
        }
        super.createMatrices();
    }

    @Override
    protected void recalculateBackgroundImage() {
        super.recalculateBackgroundImage();
        this.classImage = new BufferedImage(400, 300, 2);
        int width = 400 / this.dimensions[0];
        int height = 300 / this.dimensions[1];
        for (int i = 0; i < this.dimensions[0]; ++i) {
            for (int j = 0; j < this.dimensions[1]; ++j) {
                this.interpolateRect(this.classImage, width * i, height * j, width, height, this.classificationMatrix, i, j, 1.0, this.colorizer);
            }
        }
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        JComponent comp = super.getOptionsComponent(index);
        if (comp != null) {
            this.lastPlotterComponentIndex = index;
            return comp;
        }
        if (index == this.lastPlotterComponentIndex + 1) {
            JLabel label = new JLabel("Transparency");
            label.setToolTipText("Select level of transparency");
            return label;
        }
        if (index == this.lastPlotterComponentIndex + 2) {
            String toolTip = "Select level of transparency";
            final JSlider alphaSlider = new JSlider(0, 100, 50);
            alphaSlider.setToolTipText(toolTip);
            alphaSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SOMModelPlotter.this.setAlphaLevel((double)alphaSlider.getValue() / 100.0);
                }
            });
            return alphaSlider;
        }
        return null;
    }

    public void setAlphaLevel(double alphaLevel) {
        this.alphaLevel = (float)alphaLevel;
        if (this.show) {
            this.repaint();
        }
    }
}

