/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessSetupError;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.ROCBias;
import com.rapidminer.tools.math.ROCData;
import com.rapidminer.tools.math.ROCDataGenerator;
import java.util.List;

public class ROCChartGenerator
extends Operator {
    public static final String PARAMETER_USE_EXAMPLE_WEIGHTS = "use_example_weights";
    public static final String PARAMETER_USE_MODEL = "use_model";
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private InputPort modelInput = (InputPort)this.getInputPorts().createPort("model");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public ROCChartGenerator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, "label", 1){

            @Override
            public void makeAdditionalChecks(ExampleSetMetaData emd) throws UndefinedParameterError {
                MetaDataInfo contained = emd.containsSpecialAttribute("prediction");
                if (!ROCChartGenerator.this.getParameterAsBoolean(ROCChartGenerator.PARAMETER_USE_MODEL) && contained != MetaDataInfo.YES) {
                    if (contained == MetaDataInfo.NO) {
                        this.createError(ProcessSetupError.Severity.ERROR, "exampleset.needs_prediction", new Object[0]);
                    } else {
                        this.createError(ProcessSetupError.Severity.WARNING, "exampleset.needs_prediction", new Object[0]);
                    }
                }
            }
        });
        this.modelInput.addPrecondition(new SimplePrecondition(this.modelInput, new MetaData(Model.class)){

            @Override
            protected boolean isMandatory() {
                return ROCChartGenerator.this.getParameterAsBoolean(ROCChartGenerator.PARAMETER_USE_MODEL);
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105);
        }
        if (!exampleSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 101, "ROC Charts", exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getLabel().getMapping().getValues().size() != 2) {
            throw new UserError((Operator)this, 114, "ROC Charts", exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getPredictedLabel() != null && this.getParameterAsBoolean(PARAMETER_USE_MODEL)) {
            this.getLogger().warning("Input example already has a predicted label which will be removed.");
            PredictionModel.removePredictedLabel(exampleSet);
        }
        if (exampleSet.getAttributes().getPredictedLabel() == null && !this.getParameterAsBoolean(PARAMETER_USE_MODEL)) {
            throw new UserError((Operator)this, 107);
        }
        Model model = null;
        if (this.getParameterAsBoolean(PARAMETER_USE_MODEL)) {
            model = (Model)this.modelInput.getData();
            exampleSet = model.apply(exampleSet);
        }
        if (exampleSet.getAttributes().getPredictedLabel() == null) {
            throw new UserError((Operator)this, 107);
        }
        ROCDataGenerator rocDataGenerator = new ROCDataGenerator(1.0, 1.0);
        ROCData rocPoints = rocDataGenerator.createROCData(exampleSet, this.getParameterAsBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS), ROCBias.getROCBiasParameter(this));
        rocDataGenerator.createROCPlotDialog(rocPoints);
        PredictionModel.removePredictedLabel(exampleSet);
        this.modelOutput.deliver(model);
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS, "Indicates if example weights should be used for calculations (use 1 as weights for each example otherwise).", true));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_MODEL, "If checked a given model will be applied for generating ROCChart. If not the examples set must have a predicted label.", true));
        types.add(ROCBias.makeParameterType());
        return types;
    }
}

