/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeValue;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ProcessLogOperator
extends Operator {
    public static final String PARAMETER_COLUMN_NAME = "column_name";
    public static final String PARAMETER_COLUMN_VALUE = "value";
    public static final String PARAMETER_FILENAME = "filename";
    public static final String PARAMETER_LOG = "log";
    public static final String PARAMETER_PERSISTENT = "persistent";
    public static final String PARAMETER_SORTING_TYPE = "sorting_type";
    public static final String PARAMETER_SORTING_DIMENSION = "sorting_dimension";
    public static final String PARAMETER_SORTING_K = "sorting_k";
    public static final String[] SORTING_TYPES = new String[]{"none", "top-k", "bottom-k"};
    public static final int SORTING_TYPE_NONE = 0;
    public static final int SORTING_TYPE_TOP_K = 1;
    public static final int SORTING_TYPE_BOTTOM_K = 2;
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public ProcessLogOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double fetchValue(ParameterTypeValue.OperatorValueSelection selection, int column) throws UndefinedParameterError {
        Operator operator = this.lookupOperator(selection.getOperator());
        if (operator == null) {
            this.logWarning("Unknown operator '" + selection.getOperator() + "' in '" + selection + "'");
            return Double.NaN;
        }
        if (selection.isValue()) {
            Value value = operator.getValue(selection.getValueName());
            if (value == null) {
                this.getLogger().warning("No such value in '" + selection + "'");
                return Double.NaN;
            }
            if (!value.isNominal()) return (Double)value.getValue();
            Object actualValue = value.getValue();
            if (actualValue == null) return Double.NaN;
            String valueString = value.getValue().toString();
            SimpleDataTable table = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
            return table.mapString(column, valueString);
        }
        ParameterType parameterType = operator.getParameterType(selection.getParameterName());
        if (parameterType == null) {
            this.logWarning("No such parameter in '" + selection + "'");
            return Double.NaN;
        }
        if (!parameterType.isNumerical()) {
            String value = parameterType.toString(operator.getParameter(selection.getParameterName()));
            SimpleDataTable table = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
            return table.mapString(column, value);
        }
        try {
            return Double.parseDouble(operator.getParameter(selection.getParameterName()).toString());
        }
        catch (NumberFormatException e) {
            this.logWarning("Cannot parse parameter value of '" + selection + "'");
            return Double.NaN;
        }
    }

    private Collection<ParameterTypeValue.OperatorValueSelection> getValueDescriptions() throws UndefinedParameterError {
        List<String[]> parameters = this.getParameterList(PARAMETER_LOG);
        LinkedList<ParameterTypeValue.OperatorValueSelection> valueSelections = new LinkedList<ParameterTypeValue.OperatorValueSelection>();
        for (String[] pair : parameters) {
            valueSelections.add(ParameterTypeValue.transformString2OperatorValueSelection(pair[1]));
        }
        return valueSelections;
    }

    public void createDataTable() throws OperatorException {
        List<String[]> parameters = this.getParameterList(PARAMETER_LOG);
        String[] columnNames = new String[parameters.size()];
        Iterator<String[]> i = parameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            String[] parameter = i.next();
            columnNames[j] = parameter[0];
            ++j;
        }
        this.getProcess().addDataTable(new SimpleDataTable(this.getName(), columnNames));
    }

    @Override
    public void doWork() throws OperatorException {
        SimpleDataTable dataTable = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
        if (dataTable == null) {
            this.createDataTable();
        }
        DataTableRow row = this.fetchAllValues();
        if (this.getParameterAsInt(PARAMETER_SORTING_TYPE) == 0 && this.getParameterAsBoolean(PARAMETER_PERSISTENT)) {
            this.writeOnline(row);
        }
        this.dummyPorts.passDataThrough();
    }

    private void writeOnline(DataTableRow row) throws UserError {
        DataTable table = this.getProcess().getDataTable(this.getName());
        File outputFile = this.getParameterAsFile(PARAMETER_FILENAME, true);
        try {
            int j;
            PrintWriter out;
            if (!outputFile.exists() || this.getApplyCount() == 1) {
                out = new PrintWriter(new FileWriter(outputFile));
                out.println("# Generated by " + this.getName() + "[" + this.getClass().getName() + "]");
                for (j = 0; j < table.getNumberOfColumns(); ++j) {
                    out.print((j != 0 ? "\t" : "# ") + table.getColumnName(j));
                }
                out.println();
                out.close();
            }
            out = new PrintWriter(new FileWriter(outputFile, true));
            for (j = 0; j < row.getNumberOfValues(); ++j) {
                out.print((j != 0 ? "\t" : "") + table.getValueAsString(row, j));
            }
            out.println();
            out.close();
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 303, outputFile, e.getMessage());
        }
    }

    private DataTableRow fetchAllValues() throws UndefinedParameterError {
        Collection<ParameterTypeValue.OperatorValueSelection> valueDescriptions = this.getValueDescriptions();
        double[] row = new double[valueDescriptions.size()];
        int i = 0;
        for (ParameterTypeValue.OperatorValueSelection selection : valueDescriptions) {
            row[i] = this.fetchValue(selection, i);
            ++i;
        }
        SimpleDataTableRow dataRow = new SimpleDataTableRow(row, null);
        SimpleDataTable dataTable = (SimpleDataTable)this.getProcess().getDataTable(this.getName());
        int sortingType = this.getParameterAsInt(PARAMETER_SORTING_TYPE);
        if (sortingType == 0 || dataTable.getNumberOfRows() < this.getParameterAsInt(PARAMETER_SORTING_K)) {
            dataTable.add(dataRow);
        } else {
            String sortingDimension = this.getParameterAsString(PARAMETER_SORTING_DIMENSION);
            int sortingDimensionIndex = dataTable.getColumnIndex(sortingDimension);
            if (dataTable.isNominal(sortingDimensionIndex)) {
                String currentWorst = null;
                int currentWorstIndex = -1;
                for (int r = 0; r < dataTable.getNumberOfRows(); ++r) {
                    double currentValue = dataTable.getRow(r).getValue(sortingDimensionIndex);
                    String currentNominalValue = dataTable.mapIndex(sortingDimensionIndex, (int)currentValue);
                    if (currentWorst != null && (sortingType != 1 || currentNominalValue.compareTo(currentWorst) >= 0) && (sortingType != 2 || currentNominalValue.compareTo(currentWorst) <= 0)) continue;
                    currentWorst = currentNominalValue;
                    currentWorstIndex = r;
                }
                double candidateValue = dataRow.getValue(sortingDimensionIndex);
                String candidateNominalValue = dataTable.mapIndex(sortingDimensionIndex, (int)candidateValue);
                if (currentWorstIndex >= 0 && sortingType == 1 && candidateNominalValue.compareTo(currentWorst) > 0 || sortingType == 2 && candidateNominalValue.compareTo(currentWorst) < 0) {
                    dataTable.remove(dataTable.getRow(currentWorstIndex));
                    dataTable.add(dataRow);
                    dataTable.cleanMappingTables();
                }
            } else {
                double currentWorst = Double.NaN;
                int currentWorstIndex = -1;
                for (int r = 0; r < dataTable.getNumberOfRows(); ++r) {
                    double currentValue = dataTable.getRow(r).getValue(sortingDimensionIndex);
                    if (!(Double.isNaN(currentWorst) || sortingType == 1 && currentValue < currentWorst) && (sortingType != 2 || !(currentValue > currentWorst))) continue;
                    currentWorst = currentValue;
                    currentWorstIndex = r;
                }
                double candidateValue = dataRow.getValue(sortingDimensionIndex);
                if (currentWorstIndex >= 0 && sortingType == 1 && candidateValue > currentWorst || sortingType == 2 && candidateValue < currentWorst) {
                    dataTable.remove(dataTable.getRow(currentWorstIndex));
                    dataTable.add(dataRow);
                    dataTable.cleanMappingTables();
                }
            }
        }
        return dataRow;
    }

    @Override
    public void processFinished() throws OperatorException {
        DataTable table;
        super.processFinished();
        if (!this.getParameterAsBoolean(PARAMETER_PERSISTENT) && (table = this.getProcess().getDataTable(this.getName())) != null) {
            File file = null;
            try {
                file = this.getParameterAsFile(PARAMETER_FILENAME, true);
            }
            catch (UndefinedParameterError e) {
                // empty catch block
            }
            if (file != null) {
                this.log("Writing data to '" + file.getName() + "'");
                PrintWriter out = null;
                try {
                    out = new PrintWriter(new FileWriter(file));
                    table.write(out);
                }
                catch (IOException e) {
                    throw new UserError((Operator)this, 303, file.getName(), e.getMessage());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterType type = new ParameterTypeFile(PARAMETER_FILENAME, "File to save the data to.", PARAMETER_LOG, true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeList(PARAMETER_LOG, "List of key value pairs where the key is the column name and the value specifies the process value to log.", (ParameterType)new ParameterTypeString(PARAMETER_COLUMN_NAME, "The name of the column in the process log."), (ParameterType)new ParameterTypeValue(PARAMETER_COLUMN_VALUE, "operator.OPERATORNAME.[value|parameter].VALUE_NAME"));
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SORTING_TYPE, "Indicates if the logged values should be sorted according to the specified dimension.", SORTING_TYPES, 0));
        type = new ParameterTypeString(PARAMETER_SORTING_DIMENSION, "If the sorting type is set to top-k or bottom-k, this dimension is used for sorting.", true);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, SORTING_TYPES, true, 1, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SORTING_K, "If the sorting type is set to top-k or bottom-k, this number of results will be kept.", 1, Integer.MAX_VALUE, 100);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, SORTING_TYPES, false, 1, 2));
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_PERSISTENT, "Indicates if results should be written to file immediately", false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_SORTING_TYPE, SORTING_TYPES, false, 0));
        types.add(type);
        return types;
    }
}

