/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.ArrayList;
import java.util.List;

public class ProcessLog2ExampleSet
extends Operator {
    public static final String PARAMETER_LOG_NAME = "log_name";
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("exampleSet");
    private final PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public ProcessLog2ExampleSet(OperatorDescription description) {
        super(description);
        ExampleSetMetaData newEMD = new ExampleSetMetaData();
        newEMD.attributesAreSuperset();
        newEMD.setNumberOfExamples(0);
        newEMD.getNumberOfExamples().increaseByUnknownAmount();
        this.getTransformer().addRule(new GenerateNewMDRule(this.exampleSetOutput, newEMD));
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        DataTable table = null;
        if (this.isParameterSet(PARAMETER_LOG_NAME)) {
            String dataTableName = this.getParameterAsString(PARAMETER_LOG_NAME);
            table = this.getProcess().getDataTable(dataTableName);
        } else if (this.getProcess().getDataTables().size() > 0) {
            table = this.getProcess().getDataTables().iterator().next();
            this.logNote("No log name was specified, using first data table found...");
        }
        if (table == null) {
            throw new UserError((Operator)this, 939);
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < table.getNumberOfColumns(); ++i) {
            String name = table.getColumnName(i);
            if (table.isDate(i)) {
                attributes.add(AttributeFactory.createAttribute(name, 10));
                continue;
            }
            if (table.isDateTime(i)) {
                attributes.add(AttributeFactory.createAttribute(name, 9));
                continue;
            }
            if (table.isNumerical(i)) {
                attributes.add(AttributeFactory.createAttribute(name, 4));
                continue;
            }
            attributes.add(AttributeFactory.createAttribute(name, 1));
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes);
        for (int r = 0; r < table.getNumberOfRows(); ++r) {
            DataTableRow row = table.getRow(r);
            double[] data = new double[attributes.size()];
            for (int i = 0; i < table.getNumberOfColumns(); ++i) {
                if (table.isDate(i)) {
                    data[i] = row.getValue(i);
                    continue;
                }
                if (table.isDateTime(i)) {
                    data[i] = row.getValue(i);
                    continue;
                }
                if (table.isNumerical(i)) {
                    data[i] = row.getValue(i);
                    continue;
                }
                Attribute attribute = (Attribute)attributes.get(i);
                String value = table.getValueAsString(row, i);
                data[i] = attribute.getMapping().mapString(value);
            }
            exampleTable.addDataRow(new DoubleArrayDataRow(data));
        }
        this.exampleSetOutput.deliver(exampleTable.createExampleSet());
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_LOG_NAME, "The name of the ProcessLog operator which generated the log data which should be transformed (empty: use first found data table).", true, false));
        return types;
    }
}

