/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.MetaDataInfo;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.preprocessing.NoiseOperator;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.discretization.AbsoluteDiscretization;
import com.rapidminer.operator.preprocessing.discretization.AbstractDiscretizationOperator;
import com.rapidminer.operator.preprocessing.discretization.BinDiscretization;
import com.rapidminer.operator.preprocessing.discretization.DiscretizationModel;
import com.rapidminer.operator.preprocessing.discretization.FrequencyDiscretization;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.operator.visualization.LiftParetoChart;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.OperatorService;
import java.util.List;

public class LiftParetoChartGenerator
extends Operator {
    public static final String PARAMETER_TARGET_CLASS = "target_class";
    public static final String PARAMETER_BINNING_TYPE = "binning_type";
    public static final String PARAMETER_NUMBER_OF_BINS = "number_of_bins";
    public static final String PARAMETER_SIZE_OF_BINS = "size_of_bins";
    public static final String PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS = "automatic_number_of_digits";
    public static final String PARAMETER_NUMBER_OF_DIGITS = "number_of_digits";
    public static final String PARAMETER_SHOW_BAR_LABELS = "show_bar_labels";
    public static final String PARAMETER_SHOW_CUMULATIVE_LABELS = "show_cumulative_labels";
    public static final String PARAMETER_ROTATE_LABELS = "rotate_labels";
    public static final String[] BINNING_TYPES = new String[]{"simple", "absolute", "frequency"};
    public static final int BINNING_SIMPLE = 0;
    public static final int BINNING_ABSOLUTE = 1;
    public static final int BINNING_FREQUENCY = 2;
    private final InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private final InputPort modelInput = (InputPort)this.getInputPorts().createPort("model");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private final OutputPort chartOutput = (OutputPort)this.getOutputPorts().createPort("lift pareto chart");

    public LiftParetoChartGenerator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, "label", 1));
        this.modelInput.addPrecondition(new SimplePrecondition(this.modelInput, new MetaData(Model.class)){

            @Override
            protected boolean isMandatory() {
                MetaData metaData = LiftParetoChartGenerator.this.exampleSetInput.getMetaData();
                if (metaData != null && metaData instanceof ExampleSetMetaData) {
                    ExampleSetMetaData emd = (ExampleSetMetaData)metaData;
                    return emd.containsSpecialAttribute("prediction") == MetaDataInfo.NO;
                }
                return true;
            }
        });
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
        this.getTransformer().addGenerationRule(this.chartOutput, LiftParetoChart.class);
    }

    @Override
    public void doWork() throws OperatorException {
        PreprocessingOperator noiseGeneration;
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute labelAttribute = exampleSet.getAttributes().getLabel();
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105);
        }
        if (!exampleSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 101, "Lift Charts", exampleSet.getAttributes().getLabel());
        }
        boolean cleanUp = false;
        Model model = (Model)this.modelInput.getData();
        if (exampleSet.getAttributes().getPredictedLabel() != null) {
            this.logNote("Input example already has a predicted label which will be used by this operator without re-applying the model...");
        } else {
            exampleSet = model.apply(exampleSet);
            cleanUp = true;
        }
        if (exampleSet.getAttributes().getPredictedLabel() == null) {
            throw new UserError((Operator)this, 107);
        }
        String targetClass = this.getParameter(PARAMETER_TARGET_CLASS);
        int index = labelAttribute.getMapping().getIndex(targetClass);
        if (index < 0) {
            throw new UserError((Operator)this, 143, targetClass, labelAttribute.getName());
        }
        if (targetClass.contains("(")) {
            throw new UserError((Operator)this, 207, targetClass, PARAMETER_TARGET_CLASS, "the class value is not allowed to contain parenthesis.");
        }
        if (targetClass.contains(")")) {
            throw new UserError((Operator)this, 207, targetClass, PARAMETER_TARGET_CLASS, "the class value is not allowed to contain parenthesis.");
        }
        int binningType = this.getParameterAsInt(PARAMETER_BINNING_TYPE);
        try {
            noiseGeneration = OperatorService.createOperator(NoiseOperator.class);
            noiseGeneration.setParameter("label_noise", "0.0");
            noiseGeneration.setParameter("default_attribute_noise", "1.0E-6");
            noiseGeneration.setParameter("create_view", "false");
            noiseGeneration.setParameter("include_special_attributes", "true");
            noiseGeneration.setParameter("attribute_filter_type", AttributeSubsetSelector.CONDITION_NAMES[3]);
            noiseGeneration.setParameter("regular_expression", "confidence\\(" + targetClass + "\\)");
        }
        catch (OperatorCreationException e1) {
            throw new OperatorException(this.getName() + ": Cannot create noise operator (" + e1 + ")", e1);
        }
        AbstractDiscretizationOperator discretization = null;
        try {
            if (binningType == 0) {
                discretization = OperatorService.createOperator(BinDiscretization.class);
                discretization.setParameter(PARAMETER_NUMBER_OF_BINS, this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS) + "");
                discretization.setParameter("range_name_type", DiscretizationModel.RANGE_NAME_TYPES[2]);
                discretization.setParameter(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, this.getParameterAsBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS) + "");
                discretization.setParameter(PARAMETER_NUMBER_OF_DIGITS, this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS) + "");
            } else if (binningType == 1) {
                discretization = OperatorService.createOperator(AbsoluteDiscretization.class);
                discretization.setParameter("range_name_type", DiscretizationModel.RANGE_NAME_TYPES[2]);
                discretization.setParameter(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, this.getParameterAsBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS) + "");
                discretization.setParameter(PARAMETER_NUMBER_OF_DIGITS, this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS) + "");
            } else {
                discretization = OperatorService.createOperator(FrequencyDiscretization.class);
                discretization.setParameter(PARAMETER_NUMBER_OF_BINS, this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS) + "");
                discretization.setParameter("range_name_type", DiscretizationModel.RANGE_NAME_TYPES[2]);
                discretization.setParameter(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, this.getParameterAsBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS) + "");
                discretization.setParameter(PARAMETER_NUMBER_OF_DIGITS, this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS) + "");
            }
            discretization.setParameter("create_view", "true");
            discretization.setParameter("include_special_attributes", "true");
            discretization.setParameter("attribute_filter_type", AttributeSubsetSelector.CONDITION_NAMES[3]);
            discretization.setParameter("regular_expression", "confidence\\(" + targetClass + "\\)");
        }
        catch (OperatorCreationException e) {
            throw new OperatorException(this.getName() + ": Cannot create discretization operator (" + e + ")");
        }
        ExampleSet discretizedData = (ExampleSet)exampleSet.clone();
        if (binningType == 1) {
            discretization.setParameter(PARAMETER_SIZE_OF_BINS, this.getParameterAsString(PARAMETER_SIZE_OF_BINS) + "");
            discretizedData = noiseGeneration.doWork(discretizedData);
            discretizedData = discretization.doWork(discretizedData);
        } else {
            int numberOfBins;
            int startNumber = numberOfBins = this.getParameterAsInt(PARAMETER_NUMBER_OF_BINS);
            boolean valid = false;
            while (!valid && numberOfBins >= 2) {
                try {
                    discretizedData = noiseGeneration.doWork(discretizedData);
                    discretizedData = discretization.doWork(discretizedData);
                }
                catch (UserError e) {
                    --numberOfBins;
                    continue;
                }
                valid = true;
            }
            if (numberOfBins != startNumber) {
                this.logWarning("Cannot use specified number of bins (" + startNumber + ") since the confidence values do not differ enough in order to distinguish enough bins. Using " + numberOfBins + " instead.");
            }
        }
        Attribute confidenceAttribute = discretizedData.getAttributes().get("confidence(" + targetClass + ")");
        labelAttribute = discretizedData.getAttributes().getLabel();
        SimpleDataTable dataTable = new SimpleDataTable("Lift Data", new String[]{"Confidence for " + targetClass, labelAttribute.getName()});
        for (Example example : discretizedData) {
            String confidenceValue = example.getValueAsString(confidenceAttribute);
            String classValue = example.getNominalValue(labelAttribute);
            dataTable.add(new SimpleDataTableRow(new double[]{dataTable.mapString(0, confidenceValue), dataTable.mapString(1, classValue)}));
        }
        if (cleanUp) {
            PredictionModel.removePredictedLabel(exampleSet);
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.modelOutput.deliver(model);
        this.chartOutput.deliver(new LiftParetoChart(dataTable, targetClass, this.getParameterAsBoolean(PARAMETER_SHOW_BAR_LABELS), this.getParameterAsBoolean(PARAMETER_SHOW_CUMULATIVE_LABELS), this.getParameterAsBoolean(PARAMETER_ROTATE_LABELS)));
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_TARGET_CLASS, "Indicates the target class for which the lift chart should be produced.", false, false));
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_BINNING_TYPE, "Indicates the binning type of the confidences.", BINNING_TYPES, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_BINS, "The confidence is discretized in this number of bins.", 2, Integer.MAX_VALUE, 10, false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_BINNING_TYPE, BINNING_TYPES, false, 0, 2));
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SIZE_OF_BINS, "The confidence is discretized so that each bin contains this amount of examples.", 1, Integer.MAX_VALUE, 1000);
        type.setExpert(false);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_BINNING_TYPE, BINNING_TYPES, false, 1));
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, "Indicates if the number of digits should be automatically determined for the range names.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_NUMBER_OF_DIGITS, "The minimum number of digits used for the interval names (-1: determine minimal number automatically).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        type.registerDependencyCondition(new BooleanParameterCondition(this, PARAMETER_AUTOMATIC_NUMBER_OF_DIGITS, false, false));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_BAR_LABELS, "Indicates if the bars should display the size of the bin together with the amount of the target class in the corresponding bin.", true, false));
        types.add(new ParameterTypeBoolean(PARAMETER_SHOW_CUMULATIVE_LABELS, "Indicates if the cumulative line plot should display the cumulative sizes of the bins together with the cumulative amount of the target class in the corresponding bins.", false, false));
        types.add(new ParameterTypeBoolean(PARAMETER_ROTATE_LABELS, "Indicates if the labels of the bins should be rotated.", false, false));
        return types;
    }
}

