/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterConfigurationModel;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.OperatorService;
import java.awt.Graphics;
import java.io.ObjectStreamException;
import java.util.Collections;

public class LiftParetoChart
extends ResultObjectAdapter
implements Renderable {
    private static final long serialVersionUID = 7559555964863472326L;
    private transient Plotter plotter;
    private final SimpleDataTable liftChartData;
    private final String targetValue;
    private final boolean showBarLabels;
    private final boolean showCumulativeLabels;
    private final boolean rotateLabels;

    public LiftParetoChart(SimpleDataTable liftChartData, String targetValue, boolean showBarLabels, boolean showCumulativeLabels, boolean rotateLabels) {
        this.liftChartData = liftChartData;
        this.targetValue = targetValue;
        this.showBarLabels = showBarLabels;
        this.showCumulativeLabels = showCumulativeLabels;
        this.rotateLabels = rotateLabels;
        PlotterConfigurationModel settings = new PlotterConfigurationModel("Pareto", (DataTable)liftChartData);
        this.plotter = settings.getPlotter();
    }

    public DataTable getLiftChartData() {
        return this.liftChartData;
    }

    public String getTargetValue() {
        return this.targetValue;
    }

    public boolean showBarLabels() {
        return this.showBarLabels;
    }

    public boolean showCumulativeLabels() {
        return this.showCumulativeLabels;
    }

    public boolean rotateLabels() {
        return this.rotateLabels;
    }

    @Override
    public String getName() {
        return "Lift Chart";
    }

    public String toString() {
        return "A visualization of the discretized confidences together with the counts for " + this.targetValue + ".";
    }

    public String getExtension() {
        return "lpc";
    }

    public String getFileDescription() {
        return "Lift Pareto Chart files";
    }

    @Override
    public void prepareRendering() {
        this.plotter.prepareRendering();
    }

    @Override
    public void finishRendering() {
        this.plotter.finishRendering();
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        return this.plotter.getRenderHeight(preferredHeight);
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        return this.plotter.getRenderWidth(preferredWidth);
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.plotter.render(graphics, width, height);
    }

    private Object readResolve() throws ObjectStreamException {
        PlotterConfigurationModel settings = new PlotterConfigurationModel("Pareto", (DataTable)this.liftChartData);
        this.plotter = settings.getPlotter();
        return this;
    }

    static {
        OperatorService.registerIOObjects(Collections.singletonList(LiftParetoChart.class));
    }
}

