/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.tools.math.LiftDataGenerator;
import java.util.List;

public class LiftChartGenerator
extends Operator {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private InputPort modelInput = this.getInputPorts().createPort("model", Model.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public LiftChartGenerator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, "label", 1));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Model model = (Model)this.modelInput.getData();
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105);
        }
        if (!exampleSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 101, "Lift Charts", exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getLabel().getMapping().getValues().size() != 2) {
            throw new UserError((Operator)this, 114, "Lift Charts", exampleSet.getAttributes().getLabel());
        }
        ExampleSet workingSet = (ExampleSet)exampleSet.clone();
        if (workingSet.getAttributes().getPredictedLabel() != null) {
            PredictionModel.removePredictedLabel(workingSet);
        }
        if ((workingSet = model.apply(workingSet)).getAttributes().getPredictedLabel() == null) {
            throw new UserError((Operator)this, 107);
        }
        LiftDataGenerator liftDataGenerator = new LiftDataGenerator();
        List<double[]> liftPoints = liftDataGenerator.createLiftDataList(workingSet);
        liftDataGenerator.createLiftChartPlot(liftPoints);
        PredictionModel.removePredictedLabel(workingSet);
        this.exampleSetOutput.deliver(exampleSet);
        this.modelOutput.deliver(model);
    }
}

