/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.learner.FormulaProvider;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;

public class FormulaExtractor
extends Operator {
    private InputPort modelInput = this.getInputPorts().createPort("model", Model.class);
    private OutputPort formulaOutput = (OutputPort)this.getOutputPorts().createPort("formula");
    private OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");

    public FormulaExtractor(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.modelInput, this.modelOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.formulaOutput, FormulaResult.class));
    }

    @Override
    public void doWork() throws OperatorException {
        Model model = (Model)this.modelInput.getData();
        if (model instanceof FormulaProvider) {
            this.formulaOutput.deliver(new FormulaResult(((FormulaProvider)model).getFormula()));
        } else {
            this.logWarning("The model is not capable of producing formulas, formula will be empty...");
            this.formulaOutput.deliver(new FormulaResult("Model is not capable of producing formulas."));
        }
        this.modelOutput.deliver(model);
    }

    private static class FormulaResult
    extends ResultObjectAdapter {
        private static final long serialVersionUID = 4106026192882970425L;
        private String formula;

        public FormulaResult(String formula) {
            this.formula = formula;
        }

        @Override
        public String getName() {
            return "Formula";
        }

        public String toString() {
            return this.formula;
        }
    }
}

