/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.gui.DatabaseExampleVisualization;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import com.rapidminer.tools.jdbc.connection.ConnectionProvider;
import com.rapidminer.tools.jdbc.connection.DatabaseConnectionService;
import java.util.List;

public class DatabaseExampleVisualizationOperator
extends Operator
implements ConnectionProvider {
    public static final String PARAMETER_ID_COLUMN = "id_column";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public DatabaseExampleVisualizationOperator(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        String databaseURL = null;
        String username = null;
        String password = null;
        switch (this.getParameterAsInt("define_connection")) {
            case 0: {
                ConnectionEntry entry = DatabaseConnectionService.getConnectionEntry(this.getParameterAsString("connection"));
                if (entry == null) {
                    throw new UserError((Operator)this, 318, this.getParameterAsString("connection"));
                }
                databaseURL = entry.getURL();
                username = entry.getUser();
                password = new String(entry.getPassword());
                break;
            }
            case 1: {
                databaseURL = this.getParameterAsString("database_url");
                username = this.getParameterAsString("username");
                password = this.getParameterAsString("password");
            }
        }
        DatabaseExampleVisualization visualizer = new DatabaseExampleVisualization(databaseURL, username, password, this.getParameterAsInt("database_system"), this.getParameterAsString("table_name"), this.getParameterAsString(PARAMETER_ID_COLUMN), this.getLog());
        ObjectVisualizerService.addObjectVisualizer(this, visualizer);
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(DatabaseHandler.getConnectionParameterTypes(this));
        types.addAll(DatabaseHandler.getQueryParameterTypes(this, true));
        types.add(new ParameterTypeString(PARAMETER_ID_COLUMN, "The column of the table holding the object ids for detail data querying.", false));
        return types;
    }

    @Override
    public ConnectionEntry getConnectionEntry() {
        return DatabaseHandler.getConnectionEntry(this);
    }
}

