/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.visualization.DataStatistics;
import java.util.Iterator;

public class DataStatisticsOperator
extends Operator {
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private OutputPort statisticsOutput = (OutputPort)this.getOutputPorts().createPort("statistics");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");

    public DataStatisticsOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.statisticsOutput, DataStatistics.class));
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.exampleSetInput.getData();
        eSet.recalculateAllAttributeStatistics();
        DataStatistics statistics = new DataStatistics();
        Iterator<Attribute> i = eSet.getAttributes().allAttributes();
        while (i.hasNext()) {
            statistics.addInfo(eSet, i.next());
        }
        this.exampleSetOutput.deliver(eSet);
        this.statisticsOutput.deliver(statistics);
    }
}

