/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataStatistics
extends ResultObjectAdapter {
    private static final long serialVersionUID = -9182815345498602690L;
    private List<String> statistics = new LinkedList<String>();

    @Override
    public String getName() {
        return "Data Statistics";
    }

    public void addInfo(ExampleSet exampleSet, Attribute attribute) {
        StringBuffer result = new StringBuffer(((Object)attribute).toString() + ": ");
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
            long minMilliseconds = (long)exampleSet.getStatistics(attribute, "minimum");
            long maxMilliseconds = (long)exampleSet.getStatistics(attribute, "maximum");
            long difference = maxMilliseconds - minMilliseconds;
            String duration = "length = ";
            if (attribute.getValueType() == 10) {
                duration = duration + Tools.formatIntegerIfPossible(Math.round((double)difference / 8.64E7)) + " days";
            } else if (attribute.getValueType() == 11) {
                duration = duration + Tools.formatIntegerIfPossible(Math.round((double)difference / 3600000.0)) + " hours";
            } else if (attribute.getValueType() == 9) {
                duration = duration + Tools.formatIntegerIfPossible(Math.round((double)difference / 8.64E7)) + " days";
            }
            result.append(duration);
        } else if (attribute.isNominal()) {
            result.append("mode = " + attribute.getMapping().mapIndex((int)exampleSet.getStatistics(attribute, "mode")));
        } else {
            result.append("avg = " + exampleSet.getStatistics(attribute, "average") + " +/- " + Math.sqrt(exampleSet.getStatistics(attribute, "variance")));
        }
        result.append("; unknown = " + exampleSet.getStatistics(attribute, "unknown"));
        this.statistics.add(result.toString());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator<String> i = this.statistics.iterator();
        while (i.hasNext()) {
            result.append(i.next() + Tools.getLineSeparator());
        }
        return result.toString();
    }

    public String getExtension() {
        return "sta";
    }

    public String getFileDescription() {
        return "data statistics";
    }
}

