/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.AttributeSetPrecondition;
import com.rapidminer.operator.ports.metadata.ExampleSetSizePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeAttribute;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.Ontology;
import java.util.List;

public class Data2Log
extends Operator {
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_EXAMPLE_INDEX = "example_index";
    private Object currentValue = null;
    private boolean isNominal = false;

    public Data2Log(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new AttributeSetPrecondition(this.exampleSetInput, AttributeSetPrecondition.getAttributesByParameter(this, PARAMETER_ATTRIBUTE_NAME), new String[0]));
        this.exampleSetInput.addPrecondition(new ExampleSetSizePrecondition(this.exampleSetInput, this, PARAMETER_EXAMPLE_INDEX));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.addValue(new Value("data_value", "The value from the data which should be logged."){

            @Override
            public Object getValue() {
                return Data2Log.this.currentValue;
            }

            @Override
            public boolean isNominal() {
                return Data2Log.this.isNominal;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        int index = this.getParameterAsInt(PARAMETER_EXAMPLE_INDEX);
        if (index == 0) {
            throw new UserError((Operator)this, 207, "0", PARAMETER_EXAMPLE_INDEX, "only positive or negative indices are allowed");
        }
        index = index < 0 ? exampleSet.size() + index : --index;
        if (index >= exampleSet.size()) {
            throw new UserError((Operator)this, 110, index);
        }
        Example example = exampleSet.getExample(index);
        if (attribute.isNominal() || Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
            this.currentValue = example.getValueAsString(attribute);
            this.isNominal = true;
        } else {
            this.currentValue = example.getValue(attribute);
            this.isNominal = false;
        }
        this.exampleSetOutput.deliver(exampleSet);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeAttribute(PARAMETER_ATTRIBUTE_NAME, "The attribute from which the value should be taken.", this.exampleSetInput, false));
        types.add(new ParameterTypeInt(PARAMETER_EXAMPLE_INDEX, "The index of the example from which the value should be taken. Negative indices are counted from the end of the data set. Positive counting starts with 1, negative counting with -1.", -2147483647, Integer.MAX_VALUE, false));
        return types;
    }
}

