/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.DummyPortPairExtender;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

public class ClearProcessLog
extends Operator {
    public static final String PARAMETER_LOG_NAME = "log_name";
    public static final String PARAMETER_DELETE_TABLE = "delete_table";
    private PortPairExtender dummyPorts = new DummyPortPairExtender("through", this.getInputPorts(), this.getOutputPorts());

    public ClearProcessLog(OperatorDescription description) {
        super(description);
        this.dummyPorts.start();
        this.getTransformer().addRule(this.dummyPorts.makePassThroughRule());
    }

    @Override
    public void doWork() throws OperatorException {
        this.getProcess().clearDataTable(this.getParameterAsString(PARAMETER_LOG_NAME));
        if (this.getParameterAsBoolean(PARAMETER_DELETE_TABLE)) {
            this.getProcess().deleteDataTable(this.getParameterAsString(PARAMETER_LOG_NAME));
        }
        this.dummyPorts.passDataThrough();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_LOG_NAME, "The name of the log table which should be cleared.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_DELETE_TABLE, "Indicates if the complete table should be deleted. If this is not checked, only the entries will be deleted.", false));
        return types;
    }
}

