/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.significance;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.significance.SignificanceTestOperator;
import com.rapidminer.report.Readable;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.FDistribution;
import com.rapidminer.tools.math.SignificanceTestResult;

public class TTestSignificanceTestOperator
extends SignificanceTestOperator {
    public TTestSignificanceTestOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public SignificanceTestResult performSignificanceTest(PerformanceVector[] allVectors, double alpha) {
        double[][] resultMatrix = new double[allVectors.length][allVectors.length];
        for (int i = 0; i < allVectors.length; ++i) {
            int j;
            for (j = 0; j < i + 1; ++j) {
                resultMatrix[i][j] = Double.NaN;
            }
            for (j = i + 1; j < allVectors.length; ++j) {
                resultMatrix[i][j] = this.getProbability(allVectors[i].getMainCriterion(), allVectors[j].getMainCriterion());
            }
        }
        return new TTestSignificanceTestResult(allVectors, resultMatrix, alpha);
    }

    private double getProbability(PerformanceCriterion pc1, PerformanceCriterion pc2) {
        double totalDeviation = ((double)(pc1.getAverageCount() - 1) * pc1.getVariance() + (double)(pc2.getAverageCount() - 1) * pc2.getVariance()) / (double)(pc1.getAverageCount() + pc2.getAverageCount() - 2);
        double factor = 1.0 / (1.0 / (double)pc1.getAverageCount() + 1.0 / (double)pc2.getAverageCount());
        double diff = pc1.getAverage() - pc2.getAverage();
        double t = factor * diff * diff / totalDeviation;
        FDistribution fDist = new FDistribution(1, pc1.getAverageCount() + pc2.getAverageCount() - 2);
        double prob = fDist.getProbabilityForValue(t);
        prob = prob < 0.0 ? 1.0 : 1.0 - prob;
        return prob;
    }

    @Override
    public int getMinSize() {
        return 2;
    }

    @Override
    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public static class TTestSignificanceTestResult
    extends SignificanceTestResult
    implements Readable {
        private static final long serialVersionUID = -5412090499056975997L;
        private final PerformanceVector[] allVectors;
        private final double[][] probMatrix;
        private double alpha = 0.05;

        public TTestSignificanceTestResult(PerformanceVector[] allVectors, double[][] probMatrix, double alpha) {
            this.allVectors = allVectors;
            this.probMatrix = probMatrix;
            this.alpha = alpha;
        }

        @Override
        public String getName() {
            return "Pairwise t-Test";
        }

        @Override
        public double getProbability() {
            return Double.NaN;
        }

        @Override
        public String toString() {
            int i;
            StringBuffer result = new StringBuffer();
            result.append("Probabilities for random values with the same result:" + Tools.getLineSeparator());
            for (i = 0; i < this.allVectors.length; ++i) {
                for (int j = 0; j < this.allVectors.length; ++j) {
                    if (!Double.isNaN(this.probMatrix[i][j])) {
                        result.append(Tools.formatNumber(this.probMatrix[i][j]) + "\t");
                        continue;
                    }
                    result.append("-----\t");
                }
                result.append(Tools.getLineSeparator());
            }
            result.append("Values smaller than alpha=" + Tools.formatNumber(this.alpha) + " indicate a probably significant difference between the mean values!" + Tools.getLineSeparator());
            result.append("List of performance values:" + Tools.getLineSeparator());
            for (i = 0; i < this.allVectors.length; ++i) {
                result.append(i + ": " + Tools.formatNumber(this.allVectors[i].getMainCriterion().getAverage()) + " +/- " + Tools.formatNumber(Math.sqrt(this.allVectors[i].getMainCriterion().getVariance())) + Tools.getLineSeparator());
            }
            return result.toString();
        }

        @Override
        public boolean isInTargetEncoding() {
            return false;
        }

        public PerformanceVector[] getAllVectors() {
            return this.allVectors;
        }

        public double[][] getProbMatrix() {
            return this.probMatrix;
        }

        public double getAlpha() {
            return this.alpha;
        }
    }
}

