/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.significance;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.math.SignificanceTestResult;
import java.util.List;

public abstract class SignificanceTestOperator
extends Operator {
    public static final String PARAMETER_ALPHA = "alpha";
    private PortPairExtender performanceExtender = new PortPairExtender("performance", this.getInputPorts(), this.getOutputPorts(), new MetaData(PerformanceVector.class));
    private OutputPort significanceOutput = (OutputPort)this.getOutputPorts().createPort("significance");

    public SignificanceTestOperator(OperatorDescription description) {
        super(description);
        this.performanceExtender.start();
        this.getTransformer().addRule(new GenerateNewMDRule(this.significanceOutput, SignificanceTestResult.class));
        this.getTransformer().addRule(this.performanceExtender.makePassThroughRule());
    }

    public abstract SignificanceTestResult performSignificanceTest(PerformanceVector[] var1, double var2) throws OperatorException;

    public abstract int getMinSize();

    public abstract int getMaxSize();

    @Override
    public void doWork() throws OperatorException {
        List<PerformanceVector> allVectors = this.performanceExtender.getData();
        if (allVectors.size() < this.getMinSize()) {
            throw new UserError((Operator)this, 123, PerformanceVector.class, this.getMinSize() + "");
        }
        if (allVectors.size() > this.getMaxSize()) {
            throw new UserError((Operator)this, 124, PerformanceVector.class, this.getMaxSize() + "");
        }
        PerformanceVector[] allVectorsArray = new PerformanceVector[allVectors.size()];
        allVectors.toArray(allVectorsArray);
        SignificanceTestResult result = this.performSignificanceTest(allVectorsArray, this.getParameterAsDouble(PARAMETER_ALPHA));
        this.performanceExtender.passDataThrough();
        this.significanceOutput.deliver(result);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_ALPHA, "The probability threshold which determines if differences are considered as significant.", 0.0, 1.0, 0.05));
        return types;
    }
}

