/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.clustering.exampledistribution;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughOrGenerateRule;
import com.rapidminer.operator.validation.clustering.exampledistribution.ExampleDistributionMeasure;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.ClassNameMapper;
import java.util.List;

public class ExampleDistributionEvaluator
extends Operator {
    public static final String PARAMETER_MEASURE = "measure";
    private static final String[] DEFAULT_MEASURES = new String[]{"com.rapidminer.operator.validation.clustering.exampledistribution.SumOfSquares", "com.rapidminer.operator.validation.clustering.exampledistribution.GiniCoefficient"};
    private ClassNameMapper MEASURE_MAP;
    private double distribution = 0.0;
    private InputPort clusterModelInput = this.getInputPorts().createPort("cluster model", ClusterModel.class);
    private InputPort performanceInput = (InputPort)this.getInputPorts().createPort("performance vector");
    private OutputPort clusterModelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance vector");

    public ExampleDistributionEvaluator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.clusterModelInput, this.clusterModelOutput);
        this.getTransformer().addRule(new PassThroughOrGenerateRule(this.performanceInput, this.performanceOutput, new MetaData(PerformanceVector.class)));
        this.addValue(new ValueDouble("item_distribution", "The distribution of items over clusters.", false){

            @Override
            public double getDoubleValue() {
                return ExampleDistributionEvaluator.this.distribution;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        ClusterModel model = (ClusterModel)this.clusterModelInput.getData();
        ExampleDistributionMeasure measure = (ExampleDistributionMeasure)this.MEASURE_MAP.getInstantiation(this.getParameterAsString(PARAMETER_MEASURE));
        int totalNumberOfItems = 0;
        int[] count = new int[model.getNumberOfClusters()];
        for (int i = 0; i < model.getNumberOfClusters(); ++i) {
            int numItemsInCluster = model.getCluster(i).getNumberOfExamples();
            totalNumberOfItems += numItemsInCluster;
            count[i] = numItemsInCluster;
        }
        PerformanceVector performance = (PerformanceVector)this.performanceInput.getDataOrNull();
        if (performance == null) {
            performance = new PerformanceVector();
        }
        this.distribution = measure.evaluate(count, totalNumberOfItems);
        EstimatedPerformance criterion = new EstimatedPerformance("Example distribution", this.distribution, 1, false);
        performance.addCriterion(criterion);
        this.clusterModelOutput.deliver(model);
        this.performanceOutput.deliver(performance);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        this.MEASURE_MAP = new ClassNameMapper(DEFAULT_MEASURES);
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeStringCategory type = new ParameterTypeStringCategory(PARAMETER_MEASURE, "the item distribution measure to apply", this.MEASURE_MAP.getShortClassNames(), "SumOfSquares", true);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

