/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.clustering;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughOrGenerateRule;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;

public class ClusterNumberEvaluator
extends Operator {
    private int numberOfClusters;
    private InputPort clusterModelInput = this.getInputPorts().createPort("cluster model", ClusterModel.class);
    private OutputPort clusterModelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");
    private InputPort performanceInput = (InputPort)this.getInputPorts().createPort("performance");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");

    public ClusterNumberEvaluator(OperatorDescription description) {
        super(description);
        this.performanceInput.addPrecondition(new SimplePrecondition(this.performanceInput, new MetaData(PerformanceVector.class), false));
        this.getTransformer().addRule(new PassThroughOrGenerateRule(this.performanceInput, this.performanceOutput, new MetaData(PerformanceVector.class)));
        this.getTransformer().addPassThroughRule(this.clusterModelInput, this.clusterModelOutput);
        this.addValue(new ValueDouble("clusternumber", "The number of clusters.", false){

            @Override
            public double getDoubleValue() {
                return ClusterNumberEvaluator.this.numberOfClusters;
            }
        });
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.clusterModelOutput) {
            return this.getParameterAsBoolean("keep_cluster_model");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public void doWork() throws OperatorException {
        ClusterModel model = (ClusterModel)this.clusterModelInput.getData();
        this.numberOfClusters = model.getNumberOfClusters();
        int numItems = 0;
        for (int i = 0; i < model.getNumberOfClusters(); ++i) {
            numItems += model.getCluster(i).getNumberOfExamples();
        }
        PerformanceVector performance = (PerformanceVector)this.performanceInput.getDataOrNull();
        if (performance == null) {
            performance = new PerformanceVector();
        }
        EstimatedPerformance pc = new EstimatedPerformance("Number of clusters", model.getNumberOfClusters(), 1, true);
        performance.addCriterion(pc);
        pc = new EstimatedPerformance("Cluster Number Index", 1.0 - (double)model.getNumberOfClusters() / (double)numItems, numItems, false);
        performance.addCriterion(pc);
        this.clusterModelOutput.deliver(model);
        this.performanceOutput.deliver(performance);
    }
}

