/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughOrGenerateRule;
import com.rapidminer.operator.similarity.SimilarityMeasureObject;
import com.rapidminer.tools.math.similarity.DistanceMeasure;

public class ClusterDensityEvaluator
extends Operator {
    private double avgClusterSim = 0.0;
    private InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set");
    private InputPort distanceInput = this.getInputPorts().createPort("distance measure", SimilarityMeasureObject.class);
    private InputPort performanceInput = (InputPort)this.getInputPorts().createPort("performance vector");
    private InputPort clusterModelInput = this.getInputPorts().createPort("cluster model", ClusterModel.class);
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance vector");

    public ClusterDensityEvaluator(OperatorDescription description) {
        super(description);
        this.exampleSetInput.addPrecondition(new ExampleSetPrecondition(this.exampleSetInput, 0, "id"));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addRule(new PassThroughOrGenerateRule(this.performanceInput, this.performanceOutput, new MetaData(PerformanceVector.class)));
        this.addValue(new ValueDouble("clusterdensity", "Avg. within cluster similarity/distance", false){

            @Override
            public double getDoubleValue() {
                return ClusterDensityEvaluator.this.avgClusterSim;
            }
        });
    }

    @Override
    public void doWork() throws OperatorException {
        SimilarityMeasureObject simMeasure = (SimilarityMeasureObject)this.distanceInput.getData();
        DistanceMeasure measure = simMeasure.getDistanceMeasure();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        ClusterModel clusterModel = (ClusterModel)this.clusterModelInput.getData();
        PerformanceVector performance = (PerformanceVector)this.performanceInput.getDataOrNull();
        if (performance == null) {
            performance = new PerformanceVector();
        }
        double[] avgWithinClusterSims = this.withinClusterAvgSim(clusterModel, exampleSet, measure);
        this.avgClusterSim = avgWithinClusterSims[clusterModel.getNumberOfClusters()];
        EstimatedPerformance withinClusterSim = null;
        withinClusterSim = measure.isDistance() ? new EstimatedPerformance("Avg. within cluster distance", this.avgClusterSim, 1, true) : new EstimatedPerformance("Avg. within cluster similarity", this.avgClusterSim, 1, false);
        performance.addCriterion(withinClusterSim);
        for (int i = 0; i < clusterModel.getNumberOfClusters(); ++i) {
            EstimatedPerformance withinSingleClusterSim = null;
            withinSingleClusterSim = measure.isDistance() ? new EstimatedPerformance("Avg. within cluster distance for cluster " + clusterModel.getCluster(i).getClusterId(), avgWithinClusterSims[i], 1, true) : new EstimatedPerformance("Avg. within cluster similarity for cluster " + clusterModel.getCluster(i).getClusterId(), avgWithinClusterSims[i], 1, false);
            performance.addCriterion(withinSingleClusterSim);
        }
        this.exampleSetOutput.deliver(exampleSet);
        this.performanceOutput.deliver(performance);
    }

    private double[] withinClusterAvgSim(ClusterModel clusterModel, ExampleSet exampleSet, DistanceMeasure measure) {
        Attribute id = exampleSet.getAttributes().getId();
        double[] result = new double[clusterModel.getNumberOfClusters() + 1];
        for (Example example : exampleSet) {
            int clusterIndex = id.isNominal() ? clusterModel.getClusterIndexOfId(example.getValueAsString(id)) : clusterModel.getClusterIndexOfId(example.getValue(id));
            for (Example compExample : exampleSet) {
                int compClusterIndex = id.isNominal() ? clusterModel.getClusterIndexOfId(compExample.getValueAsString(id)) : clusterModel.getClusterIndexOfId(compExample.getValue(id));
                if (clusterIndex != compClusterIndex) continue;
                double v = measure.calculateSimilarity(example, compExample);
                int n = clusterIndex;
                result[n] = result[n] + v;
            }
        }
        double sum = 0.0;
        int totalCount = 0;
        for (int i = 0; i < clusterModel.getNumberOfClusters(); ++i) {
            sum += result[i];
            int clusterSize = clusterModel.getCluster(i).getNumberOfExamples();
            int n = i;
            double d = result[n] / (double)clusterSize;
            result[n] = d;
            result[i] = d;
            totalCount += clusterSize;
        }
        result[clusterModel.getNumberOfClusters()] = sum / (double)totalCount;
        return result;
    }
}

