/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.clustering;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewMDRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughOrGenerateRule;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.divergences.SquaredEuclideanDistance;
import com.rapidminer.tools.math.similarity.numerical.EuclideanDistance;
import java.util.List;

public class CentroidBasedEvaluator
extends Operator {
    public static final String PARAMETER_MAIN_CRITERION = "main_criterion";
    public static final String PARAMETER_MAIN_CRITERION_ONLY = "main_criterion_only";
    public static final String PARAMETER_NORMALIZE = "normalize";
    public static final String PARAMETER_MAXIMIZE = "maximize";
    private double avgWithinClusterDistance;
    private double daviesBouldin;
    public static final String[] CRITERIA_LIST = new String[]{"Avg. within centroid distance", "Davies Bouldin"};
    public static final String[] CRITERIA_LIST_SHORT = new String[]{"avg_within_distance", "DaviesBouldin"};
    private InputPort exampleSetInput = this.getInputPorts().createPort("example set", ExampleSet.class);
    private InputPort clusterModelInput = this.getInputPorts().createPort("cluster model", CentroidClusterModel.class);
    private InputPort performanceInput = (InputPort)this.getInputPorts().createPort("performance");
    private OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance");
    private OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("example set");
    private OutputPort clusterModelOutput = (OutputPort)this.getOutputPorts().createPort("cluster model");

    public CentroidBasedEvaluator(OperatorDescription description) {
        super(description);
        this.performanceInput.addPrecondition(new SimplePrecondition(this.performanceInput, new MetaData(PerformanceVector.class), false));
        this.getTransformer().addRule(new PassThroughOrGenerateRule(this.performanceInput, this.performanceOutput, new MetaData(PerformanceVector.class)));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.exampleSetOutput);
        this.getTransformer().addPassThroughRule(this.clusterModelInput, this.clusterModelOutput);
        this.getTransformer().addRule(new GenerateNewMDRule(this.performanceOutput, PerformanceVector.class));
        this.addValue(new ValueDouble(CRITERIA_LIST_SHORT[0], CRITERIA_LIST[0], false){

            @Override
            public double getDoubleValue() {
                return CentroidBasedEvaluator.this.avgWithinClusterDistance;
            }
        });
        this.addValue(new ValueDouble(CRITERIA_LIST_SHORT[1], CRITERIA_LIST[1], false){

            @Override
            public double getDoubleValue() {
                return CentroidBasedEvaluator.this.daviesBouldin;
            }
        });
    }

    @Override
    public boolean shouldAutoConnect(OutputPort port) {
        if (port == this.clusterModelOutput) {
            return this.getParameterAsBoolean("keep_cluster_model");
        }
        if (port == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(port);
    }

    @Override
    public void doWork() throws OperatorException {
        CentroidClusterModel clusterModel = (CentroidClusterModel)this.clusterModelInput.getData();
        ExampleSet exampleSet = (ExampleSet)this.exampleSetInput.getData();
        PerformanceVector performance = (PerformanceVector)this.performanceInput.getDataOrNull();
        if (performance == null) {
            performance = new PerformanceVector();
        }
        int mainCriterionIndex = this.getParameterAsInt(PARAMETER_MAIN_CRITERION);
        boolean onlyMainCriterion = this.getParameterAsBoolean(PARAMETER_MAIN_CRITERION_ONLY);
        double multFactor = -1.0;
        if (this.getParameterAsBoolean(PARAMETER_MAXIMIZE)) {
            multFactor = 1.0;
        }
        double divisionFactor = 1.0;
        if (this.getParameterAsBoolean(PARAMETER_NORMALIZE)) {
            divisionFactor = exampleSet.getAttributes().size();
        }
        double[] averageWithinDistance = this.getAverageWithinDistance(clusterModel, exampleSet);
        this.avgWithinClusterDistance = averageWithinDistance[clusterModel.getNumberOfClusters()];
        EstimatedPerformance withinClusterDist = new EstimatedPerformance(CRITERIA_LIST[0], multFactor * this.avgWithinClusterDistance / divisionFactor, 1, false);
        if (mainCriterionIndex == 0 || !onlyMainCriterion) {
            performance.addCriterion(withinClusterDist);
        }
        for (int i = 0; i < clusterModel.getNumberOfClusters(); ++i) {
            EstimatedPerformance withinDistance = new EstimatedPerformance(CRITERIA_LIST[0] + "_cluster_" + clusterModel.getCluster(i).getClusterId(), multFactor * averageWithinDistance[i] / divisionFactor, 1, false);
            if (mainCriterionIndex != 0 && onlyMainCriterion) continue;
            performance.addCriterion(withinDistance);
        }
        this.daviesBouldin = this.getDaviesBouldin(clusterModel, exampleSet);
        EstimatedPerformance daviesBouldinCriterion = new EstimatedPerformance(CRITERIA_LIST[1], multFactor * this.daviesBouldin / divisionFactor, 1, false);
        if (mainCriterionIndex == 1 || !onlyMainCriterion) {
            performance.addCriterion(daviesBouldinCriterion);
        }
        performance.setMainCriterionName(CRITERIA_LIST[mainCriterionIndex]);
        this.performanceOutput.deliver(performance);
        this.exampleSetOutput.deliver(exampleSet);
        this.clusterModelOutput.deliver(clusterModel);
    }

    private double[] getAverageWithinDistance(CentroidClusterModel model, ExampleSet exampleSet) throws OperatorException {
        SquaredEuclideanDistance measure = new SquaredEuclideanDistance();
        ((DistanceMeasure)measure).init(exampleSet);
        int numberOfClusters = model.getNumberOfClusters();
        double[] result = new double[numberOfClusters + 1];
        int[] clusterSizes = new int[numberOfClusters];
        int[] clusterIndices = model.getClusterAssignments(exampleSet);
        int i = 0;
        for (Example example : exampleSet) {
            int n = clusterIndices[i];
            clusterSizes[n] = clusterSizes[n] + 1;
            int n2 = clusterIndices[i];
            result[n2] = result[n2] + measure.calculateDistance(example, model.getCentroidCoordinates(clusterIndices[i]));
            ++i;
        }
        int totalSize = 0;
        for (i = 0; i < numberOfClusters; ++i) {
            int n = numberOfClusters;
            result[n] = result[n] + result[i];
            int n3 = i;
            result[n3] = result[n3] / (double)clusterSizes[i];
            totalSize += clusterSizes[i];
        }
        int n = numberOfClusters;
        result[n] = result[n] / (double)totalSize;
        return result;
    }

    private double getDaviesBouldin(CentroidClusterModel model, ExampleSet exampleSet) throws OperatorException {
        EuclideanDistance measure = new EuclideanDistance();
        ((DistanceMeasure)measure).init(exampleSet);
        int numberOfClusters = model.getNumberOfClusters();
        double[] withinClusterDistance = new double[numberOfClusters];
        int[] clusterSizes = new int[numberOfClusters];
        int[] clusterIndices = model.getClusterAssignments(exampleSet);
        int i = 0;
        for (Example example : exampleSet) {
            int n = clusterIndices[i];
            clusterSizes[n] = clusterSizes[n] + 1;
            int n2 = clusterIndices[i];
            withinClusterDistance[n2] = withinClusterDistance[n2] + measure.calculateDistance(example, model.getCentroidCoordinates(clusterIndices[i]));
            ++i;
        }
        for (i = 0; i < numberOfClusters; ++i) {
            int n = i;
            withinClusterDistance[n] = withinClusterDistance[n] / (double)clusterSizes[i];
        }
        double result = 0.0;
        for (i = 0; i < numberOfClusters; ++i) {
            double max = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < numberOfClusters; ++j) {
                double val;
                if (i == j || !((val = (withinClusterDistance[i] + withinClusterDistance[j]) / ((DistanceMeasure)measure).calculateDistance(model.getCentroidCoordinates(i), model.getCentroidCoordinates(j))) > max)) continue;
                max = val;
            }
            result += max;
        }
        return result / (double)model.getNumberOfClusters();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_MAIN_CRITERION, "The main criterion to use", CRITERIA_LIST, 0, false));
        types.add(new ParameterTypeBoolean(PARAMETER_MAIN_CRITERION_ONLY, "return the main criterion only", false));
        types.add(new ParameterTypeBoolean(PARAMETER_NORMALIZE, "divide the criterion by the number of features", false));
        types.add(new ParameterTypeBoolean(PARAMETER_MAXIMIZE, "do not multiply the result by minus one", false));
        return types;
    }
}

