/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;

public abstract class WrapperValidationChain
extends OperatorChain {
    private PerformanceCriterion lastPerformance;
    protected InputPort exampleSetInput = (InputPort)this.getInputPorts().createPort("example set in");
    private final OutputPort innerWeightingSetSource = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("weighting set source");
    private final InputPort innerAttributeWeightsSink = this.getSubprocess(0).getInnerSinks().createPort("attribute weights sink", AttributeWeights.class);
    private final OutputPort innerTrainSetSource = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("train set source");
    private final InputPort innerModelSink = this.getSubprocess(1).getInnerSinks().createPort("model sink", Model.class);
    private final OutputPort innerTestSetSource = (OutputPort)this.getSubprocess(2).getInnerSources().createPort("test set source");
    private final OutputPort innerModelSource = (OutputPort)this.getSubprocess(2).getInnerSources().createPort("model source");
    private final InputPort innerPerformanceSink = this.getSubprocess(2).getInnerSinks().createPort("performance vector sink", PerformanceVector.class);
    protected OutputPort performanceOutput = (OutputPort)this.getOutputPorts().createPort("performance vector out");
    protected OutputPort attributeWeightsOutput = (OutputPort)this.getOutputPorts().createPort("attribute weights out");

    public WrapperValidationChain(OperatorDescription description) {
        super(description, "Attribute Weighting", "Model Building", "Model Evaluation");
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.innerWeightingSetSource);
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.innerTrainSetSource);
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(1)));
        this.getTransformer().addPassThroughRule(this.exampleSetInput, this.innerTestSetSource);
        this.getTransformer().addPassThroughRule(this.innerModelSink, this.innerModelSource);
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(2)));
        this.getTransformer().addPassThroughRule(this.innerPerformanceSink, this.performanceOutput);
        this.getTransformer().addPassThroughRule(this.innerAttributeWeightsSink, this.attributeWeightsOutput);
        this.addValue(new ValueDouble("performance", "The last performance (main criterion)."){

            @Override
            public double getDoubleValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getAverage();
                }
                return Double.NaN;
            }
        });
        this.addValue(new ValueDouble("variance", "The variance of the last performance (main criterion)."){

            @Override
            public double getDoubleValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getVariance();
                }
                return Double.NaN;
            }
        });
    }

    void setResult(PerformanceCriterion pc) {
        this.lastPerformance = pc;
    }

    AttributeWeights useWeightingMethod(ExampleSet methodTrainingSet) throws OperatorException {
        this.innerWeightingSetSource.deliver(methodTrainingSet);
        this.getSubprocess(0).execute();
        return (AttributeWeights)this.innerAttributeWeightsSink.getData();
    }

    Model learn(ExampleSet trainingSet) throws OperatorException {
        this.innerTrainSetSource.deliver(trainingSet);
        this.getSubprocess(1).execute();
        return (Model)this.innerModelSink.getData();
    }

    PerformanceVector evaluate(ExampleSet testSet, Model model) throws OperatorException {
        this.innerTestSetSource.deliver(testSet);
        this.innerModelSource.deliver(model);
        this.getSubprocess(2).execute();
        return (PerformanceVector)this.innerPerformanceSink.getData();
    }
}

