/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetPassThroughRule;
import com.rapidminer.operator.ports.metadata.MDInteger;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.PassThroughRule;
import com.rapidminer.operator.ports.metadata.SetRelation;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.math.AverageVector;
import java.util.List;

public abstract class ValidationChain
extends OperatorChain {
    public static final String PARAMETER_CREATE_COMPLETE_MODEL = "create_complete_model";
    private final InputPort trainingSetInput = this.getInputPorts().createPort("training", ExampleSet.class);
    private final OutputPort trainingProcessExampleSetOutput = (OutputPort)this.getSubprocess(0).getInnerSources().createPort("training");
    private final InputPort trainingProcessModelInput = this.getSubprocess(0).getInnerSinks().createPort("model", Model.class);
    private final PortPairExtender throughExtender = new PortPairExtender("through", this.getSubprocess(0).getInnerSinks(), this.getSubprocess(1).getInnerSources());
    private final OutputPort applyProcessModelOutput = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("model");
    private final OutputPort applyProcessExampleSetOutput = (OutputPort)this.getSubprocess(1).getInnerSources().createPort("test set");
    private final PortPairExtender applyProcessPerformancePortExtender = new PortPairExtender("averagable", this.getSubprocess(1).getInnerSinks(), this.getOutputPorts(), new MetaData(AverageVector.class));
    private final OutputPort modelOutput = (OutputPort)this.getOutputPorts().createPort("model");
    private final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("training");
    private double lastMainPerformance = Double.NaN;
    private double lastMainVariance = Double.NaN;
    private double lastMainDeviation = Double.NaN;
    private double lastFirstPerformance = Double.NaN;
    private double lastSecondPerformance = Double.NaN;
    private double lastThirdPerformance = Double.NaN;

    public ValidationChain(OperatorDescription description) {
        super(description, "Training", "Testing");
        this.throughExtender.start();
        this.applyProcessPerformancePortExtender.ensureMinimumNumberOfPorts(1);
        InputPort inputPort = this.applyProcessPerformancePortExtender.getManagedPairs().iterator().next().getInputPort();
        inputPort.addPrecondition(new SimplePrecondition(inputPort, new MetaData(PerformanceVector.class)));
        this.applyProcessPerformancePortExtender.start();
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.trainingSetInput, this.trainingProcessExampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                try {
                    metaData.setNumberOfExamples(ValidationChain.this.getTrainingSetSize(metaData.getNumberOfExamples()));
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new ExampleSetPassThroughRule(this.trainingSetInput, this.applyProcessExampleSetOutput, SetRelation.EQUAL){

            @Override
            public ExampleSetMetaData modifyExampleSet(ExampleSetMetaData metaData) throws UndefinedParameterError {
                try {
                    metaData.setNumberOfExamples(ValidationChain.this.getTestSetSize(metaData.getNumberOfExamples()));
                }
                catch (UndefinedParameterError undefinedParameterError) {
                    // empty catch block
                }
                return super.modifyExampleSet(metaData);
            }
        });
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(new PassThroughRule(this.trainingProcessModelInput, this.applyProcessModelOutput, false));
        this.getTransformer().addRule(new PassThroughRule(this.trainingProcessModelInput, this.modelOutput, false));
        this.getTransformer().addRule(this.throughExtender.makePassThroughRule());
        this.getTransformer().addRule(new SubprocessTransformRule(this.getSubprocess(1)));
        this.getTransformer().addRule(this.applyProcessPerformancePortExtender.makePassThroughRule());
        this.getTransformer().addPassThroughRule(this.trainingSetInput, this.exampleSetOutput);
        this.addValue(new ValueDouble("performance", "The last performance average (main criterion)."){

            @Override
            public double getDoubleValue() {
                return ValidationChain.this.lastMainPerformance;
            }
        });
        this.addValue(new ValueDouble("variance", "The variance of the last performance (main criterion)."){

            @Override
            public double getDoubleValue() {
                return ValidationChain.this.lastMainVariance;
            }
        });
        this.addValue(new ValueDouble("deviation", "The standard deviation of the last performance (main criterion)."){

            @Override
            public double getDoubleValue() {
                return ValidationChain.this.lastMainDeviation;
            }
        });
        this.addValue(new ValueDouble("performance1", "The last performance average (first criterion)."){

            @Override
            public double getDoubleValue() {
                return ValidationChain.this.lastFirstPerformance;
            }
        });
        this.addValue(new ValueDouble("performance2", "The last performance average (second criterion)."){

            @Override
            public double getDoubleValue() {
                return ValidationChain.this.lastSecondPerformance;
            }
        });
        this.addValue(new ValueDouble("performance3", "The last performance average (third criterion)."){

            @Override
            public double getDoubleValue() {
                return ValidationChain.this.lastThirdPerformance;
            }
        });
    }

    protected abstract MDInteger getTrainingSetSize(MDInteger var1) throws UndefinedParameterError;

    protected abstract MDInteger getTestSetSize(MDInteger var1) throws UndefinedParameterError;

    @Override
    public boolean shouldAutoConnect(OutputPort outputPort) {
        if (outputPort == this.modelOutput) {
            return this.getParameterAsBoolean(PARAMETER_CREATE_COMPLETE_MODEL);
        }
        if (outputPort == this.exampleSetOutput) {
            return this.getParameterAsBoolean("keep_example_set");
        }
        return super.shouldAutoConnect(outputPort);
    }

    public abstract void estimatePerformance(ExampleSet var1) throws OperatorException;

    protected void executeLearner() throws OperatorException {
        this.getSubprocess(0).execute();
    }

    protected void executeEvaluator() throws OperatorException {
        this.getSubprocess(1).execute();
    }

    private final void setResult(PerformanceVector pv) {
        this.lastMainPerformance = Double.NaN;
        this.lastMainVariance = Double.NaN;
        this.lastMainDeviation = Double.NaN;
        this.lastFirstPerformance = Double.NaN;
        this.lastSecondPerformance = Double.NaN;
        this.lastThirdPerformance = Double.NaN;
        if (pv != null) {
            PerformanceCriterion criterion;
            PerformanceCriterion mainCriterion = pv.getMainCriterion();
            if (mainCriterion == null && pv.size() > 0) {
                mainCriterion = pv.getCriterion(0);
            }
            if (mainCriterion != null) {
                this.lastMainPerformance = mainCriterion.getAverage();
                this.lastMainVariance = mainCriterion.getVariance();
                this.lastMainDeviation = mainCriterion.getStandardDeviation();
            }
            if (pv.size() >= 1 && (criterion = pv.getCriterion(0)) != null) {
                this.lastFirstPerformance = criterion.getAverage();
            }
            if (pv.size() >= 2 && (criterion = pv.getCriterion(1)) != null) {
                this.lastSecondPerformance = criterion.getAverage();
            }
            if (pv.size() >= 3 && (criterion = pv.getCriterion(2)) != null) {
                this.lastThirdPerformance = criterion.getAverage();
            }
        }
    }

    @Override
    public void doWork() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.trainingSetInput.getData();
        this.estimatePerformance(eSet);
        if (this.modelOutput.isConnected()) {
            this.learn(eSet);
            this.modelOutput.deliver((IOObject)this.trainingProcessModelInput.getData());
        }
        this.exampleSetOutput.deliver(eSet);
        boolean success = false;
        for (IOObject result : this.applyProcessPerformancePortExtender.getOutputData()) {
            if (!(result instanceof PerformanceVector)) continue;
            this.setResult((PerformanceVector)result);
            success = true;
            break;
        }
        if (!success) {
            this.getLogger().warning("No performance vector found among averagable results. Performance will not be loggable.");
        }
    }

    protected final void learn(ExampleSet trainingSet) throws OperatorException {
        this.trainingProcessExampleSetOutput.deliver(trainingSet);
        this.executeLearner();
    }

    protected final void evaluate(ExampleSet testSet) throws OperatorException {
        Attribute predictedBefore = testSet.getAttributes().getPredictedLabel();
        this.applyProcessExampleSetOutput.deliver(testSet);
        this.applyProcessModelOutput.deliver((IOObject)this.trainingProcessModelInput.getData());
        this.throughExtender.passDataThrough();
        this.executeEvaluator();
        Tools.buildAverages(this.applyProcessPerformancePortExtender);
        Attribute predictedAfter = testSet.getAttributes().getPredictedLabel();
        if (predictedAfter != null && (predictedBefore == null || predictedBefore.getTableIndex() != predictedAfter.getTableIndex())) {
            PredictionModel.removePredictedLabel(testSet);
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_CREATE_COMPLETE_MODEL, "Indicates if a model of the complete data set should be additionally build after estimation.", false);
        type.setDeprecated();
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

